/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.impl;

import java.net.URI;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlRewriter {
    private static final Logger LOG = LoggerFactory.getLogger(UrlRewriter.class);
    private static final Pattern URL_PATTERN = Pattern.compile("<([^\\!:>]+)(src|href|action|background)\\s*=\\s*('[^<']*'|\"[^<\"]*\")([^>]*)>", 2);

    public UrlRewriter(Properties properties) {
    }

    public String rewriteReferer(String referer, String baseUrl, String visibleBaseUrl) {
        URI visibleBaseUri;
        URI relativeUri;
        URI uri = UriUtils.createURI(referer);
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        URI baseUri = UriUtils.createURI(baseUrl);
        if (!visibleBaseUrl.endsWith("/")) {
            visibleBaseUrl = visibleBaseUrl + "/";
        }
        if ((relativeUri = (visibleBaseUri = UriUtils.createURI(visibleBaseUrl)).relativize(uri)).equals(uri)) {
            LOG.debug("url kept unchanged: [{}]", (Object)referer);
            return referer;
        }
        URI result = baseUri.resolve(relativeUri);
        LOG.debug("referer fixed: [{}] -> [{}]", (Object)referer, (Object)result);
        return result.toString();
    }

    public String rewriteUrl(String url, String requestUrl, String baseUrl, String visibleBaseUrl, boolean absolute) {
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        URI baseUri = UriUtils.createURI(baseUrl);
        if (!visibleBaseUrl.endsWith("/")) {
            visibleBaseUrl = visibleBaseUrl + "/";
        }
        URI visibleBaseUri = UriUtils.createURI(visibleBaseUrl);
        URI requestUri = requestUrl.startsWith(visibleBaseUrl) ? UriUtils.createURI(requestUrl) : UriUtils.concatPath(baseUri, requestUrl);
        URI uri = UriUtils.resolve(url, requestUri);
        URI relativeUri = baseUri.relativize(uri = uri.normalize());
        if (relativeUri.equals(uri)) {
            LOG.debug("url kept unchanged: [{}]", (Object)url);
            return url;
        }
        URI result = visibleBaseUri.resolve(relativeUri);
        if (!absolute) {
            result = UriUtils.removeServer(result);
        }
        LOG.debug("url fixed: [{}] -> [{}]", (Object)url, (Object)result);
        return result.toString();
    }

    public CharSequence rewriteHtml(CharSequence input, String requestUrl, String baseUrlParam, String visibleBaseUrl, boolean absolute) {
        StringBuffer result = new StringBuffer(input.length());
        Matcher m = URL_PATTERN.matcher(input);
        while (m.find()) {
            LOG.trace("found match: {}", (Object)m);
            String url = input.subSequence(m.start(3) + 1, m.end(3) - 1).toString();
            String trimmedUrl = StringUtils.trim((String)url);
            if (!trimmedUrl.isEmpty() && !trimmedUrl.startsWith("#")) {
                url = this.rewriteUrl(trimmedUrl, requestUrl, baseUrlParam, visibleBaseUrl, absolute);
            } else {
                LOG.debug("url kept unchanged: [{}]", (Object)url);
            }
            url = url.replaceAll("\\$", "\\\\\\$");
            StringBuffer tagReplacement = new StringBuffer("<$1$2=\"").append(url).append("\"");
            if (m.groupCount() > 3) {
                tagReplacement.append("$4");
            }
            tagReplacement.append('>');
            LOG.trace("replacement: {}", (Object)tagReplacement);
            m.appendReplacement(result, tagReplacement.toString());
        }
        m.appendTail(result);
        return result;
    }
}

