/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension.surrogate;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.esigate.Driver;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.FetchEvent;
import org.esigate.events.impl.FragmentEvent;
import org.esigate.events.impl.ProxyEvent;
import org.esigate.extension.Extension;
import org.esigate.extension.parallelesi.Esi;
import org.esigate.extension.surrogate.CapabilitiesEvent;
import org.esigate.extension.surrogate.http.Capability;
import org.esigate.extension.surrogate.http.SurrogateCapabilities;
import org.esigate.extension.surrogate.http.SurrogateCapabilitiesHeader;
import org.esigate.http.DeleteResponseHeader;
import org.esigate.http.MoveResponseHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Surrogate
implements Extension,
IEventListener {
    private static final String H_SURROGATE_CONTROL = "Surrogate-Control";
    private static final String H_SURROGATE_CAPABILITIES = "Surrogate-Capabilities";
    private static final Logger LOG = LoggerFactory.getLogger(Surrogate.class);
    public static final String H_X_ENABLED_CAPABILITIES = "X-Esigate-Internal-Enabled-Capabilities";
    private static final String H_X_SURROGATE = "X-Esigate-Internal-Surrogate";
    private static final String H_X_ORIGINAL_CACHE_CONTROL = "X-Esigate-Int-Surrogate-OCC";
    private static final String H_X_SURROGATE_ID = "X-Esigate-Int-Surrogate-Id";
    private static final String H_X_NEXT_SURROGATE_CONTROL = "X-Esigate-Int-Surrogate-NSC";
    private String[] capabilities;
    private String esigateToken;
    public static final EventDefinition EVENT_SURROGATE_CAPABILITIES = new EventDefinition("org.esigate.surrogate.capabilities", 1);
    private static final String CAP_SURROGATE = "Surrogate/1.0";

    @Override
    public void init(Driver driver, Properties properties) {
        CapabilitiesEvent capEvent = new CapabilitiesEvent();
        capEvent.getCapabilities().add(CAP_SURROGATE);
        driver.getEventManager().fire(EVENT_SURROGATE_CAPABILITIES, capEvent);
        this.capabilities = capEvent.getCapabilities().toArray(new String[0]);
        LOG.info("Surrogate capabilities: {}", (Object)StringUtils.join((Object[])this.capabilities, (String)" "));
        this.esigateToken = "=\"" + StringUtils.join((Object[])this.capabilities, (String)" ") + "\"";
        driver.getEventManager().register(EventManager.EVENT_FETCH_PRE, this);
        driver.getEventManager().register(EventManager.EVENT_FETCH_POST, this);
        driver.getEventManager().register(EventManager.EVENT_PROXY_PRE, this);
        driver.getEventManager().register(EventManager.EVENT_PROXY_POST, this);
        driver.getEventManager().register(EventManager.EVENT_FRAGMENT_PRE, this);
        driver.getEventManager().register(EventManager.EVENT_FRAGMENT_POST, new MoveResponseHeader(H_X_ORIGINAL_CACHE_CONTROL, "Cache-Control"));
        driver.getEventManager().register(EventManager.EVENT_PROXY_POST, new DeleteResponseHeader(H_X_ENABLED_CAPABILITIES));
    }

    private static String getUniqueToken(String currentCapabilitiesHeader) {
        String token = "esigate";
        if (currentCapabilitiesHeader != null && currentCapabilitiesHeader.contains(token + "=\"")) {
            int id = 2;
            while (currentCapabilitiesHeader.contains(token + id + "=\"")) {
                ++id;
            }
            token = token + id;
        }
        return token;
    }

    @Override
    public boolean event(EventDefinition id, Event event) {
        if (EventManager.EVENT_FETCH_PRE.equals(id)) {
            FetchEvent e = (FetchEvent)event;
            e.getHttpRequest().removeHeaders(H_X_SURROGATE);
        } else if (EventManager.EVENT_FETCH_POST.equals(id)) {
            this.onPostFetch(event);
        } else if (EventManager.EVENT_FRAGMENT_PRE.equals(id)) {
            FragmentEvent e = (FragmentEvent)event;
            Header h = e.getHttpRequest().getFirstHeader(H_SURROGATE_CAPABILITIES);
            StringBuilder archCapabilities = new StringBuilder(256);
            if (h != null && !StringUtils.isEmpty((CharSequence)h.getValue())) {
                archCapabilities.append(StringUtils.defaultString((String)h.getValue()));
                archCapabilities.append(", ");
            }
            String currentCapabilitiesHeader = null;
            if (h != null) {
                currentCapabilitiesHeader = h.getValue();
            }
            String uniqueId = Surrogate.getUniqueToken(currentCapabilitiesHeader);
            e.getHttpRequest().setHeader(H_X_SURROGATE_ID, uniqueId);
            archCapabilities.append(uniqueId);
            archCapabilities.append(this.esigateToken);
            e.getHttpRequest().setHeader(H_SURROGATE_CAPABILITIES, archCapabilities.toString());
        } else if (EventManager.EVENT_PROXY_PRE.equals(id)) {
            ProxyEvent e = (ProxyEvent)event;
            if (e.getOriginalRequest().containsHeader(H_SURROGATE_CAPABILITIES)) {
                e.getOriginalRequest().setHeader(H_X_SURROGATE, "true");
            }
        } else if (EventManager.EVENT_PROXY_POST.equals(id)) {
            ProxyEvent e = (ProxyEvent)event;
            if (e.getResponse() != null) {
                Surrogate.processSurrogateControlContent((HttpResponse)e.getResponse(), e.getOriginalRequest().containsHeader(H_X_SURROGATE));
                this.removeVarySurrogateCapabilities((HttpResponse)e.getResponse());
            } else if (e.getErrorPage() != null) {
                Surrogate.processSurrogateControlContent((HttpResponse)e.getErrorPage().getHttpResponse(), e.getOriginalRequest().containsHeader(H_X_SURROGATE));
                this.removeVarySurrogateCapabilities((HttpResponse)e.getErrorPage().getHttpResponse());
            }
        }
        return true;
    }

    private void removeVarySurrogateCapabilities(HttpResponse response) {
        Header[] varyHeaders = response.getHeaders("Vary");
        if (varyHeaders != null) {
            for (Header h : varyHeaders) {
                if (!H_SURROGATE_CAPABILITIES.equals(h.getValue())) continue;
                response.removeHeader(h);
                break;
            }
        }
    }

    private void onPostFetch(Event event) {
        String[] control;
        FetchEvent e = (FetchEvent)event;
        String ourSurrogateId = e.getHttpRequest().getFirstHeader(H_X_SURROGATE_ID).getValue();
        SurrogateCapabilitiesHeader surrogateCapabilitiesHeader = SurrogateCapabilitiesHeader.fromHeaderValue(e.getHttpRequest().getFirstHeader(H_SURROGATE_CAPABILITIES).getValue());
        if (!e.getHttpResponse().containsHeader(H_SURROGATE_CONTROL) && surrogateCapabilitiesHeader.getSurrogates().size() > 1) {
            LinkedHashMap<String, List<String>> targetCapabilities = new LinkedHashMap<String, List<String>>();
            this.initSurrogateMap(targetCapabilities, surrogateCapabilitiesHeader);
            for (String c : this.capabilities) {
                if (CAP_SURROGATE.equals(c)) continue;
                String firstSurrogate = this.getFirstSurrogateFor(surrogateCapabilitiesHeader, c);
                targetCapabilities.get(firstSurrogate).add(c);
            }
            this.fixSurrogateMap(targetCapabilities, ourSurrogateId);
            StringBuilder sb = new StringBuilder();
            boolean firstDevice = true;
            for (String device : targetCapabilities.keySet()) {
                if (targetCapabilities.get(device).size() == 0) continue;
                if (!firstDevice) {
                    sb.append(", ");
                } else {
                    firstDevice = false;
                }
                sb.append("content=\"");
                boolean firstCap = true;
                for (String cap : targetCapabilities.get(device)) {
                    if (!firstCap) {
                        sb.append(" ");
                    } else {
                        firstCap = false;
                    }
                    sb.append(cap);
                }
                sb.append("\";");
                sb.append(device);
            }
            e.getHttpResponse().addHeader(H_SURROGATE_CONTROL, sb.toString());
        }
        if (!e.getHttpResponse().containsHeader(H_SURROGATE_CONTROL)) {
            return;
        }
        e.getHttpResponse().addHeader("Vary", H_SURROGATE_CAPABILITIES);
        ArrayList<String> enabledCapabilities = new ArrayList<String>();
        ArrayList<String> remainingCapabilities = new ArrayList<String>();
        ArrayList<String> newSurrogateControlL = new ArrayList<String>();
        ArrayList<String> newCacheContent = new ArrayList<String>();
        String controlHeader = e.getHttpResponse().getFirstHeader(H_SURROGATE_CONTROL).getValue();
        for (String directiveAndTarget : control = StringUtils.split((String)controlHeader, (String)",")) {
            String directive = StringUtils.strip((String)directiveAndTarget);
            int targetIndex = directive.lastIndexOf(59);
            String target = null;
            if (targetIndex > 0) {
                target = directive.substring(targetIndex + 1);
                directive = directive.substring(0, targetIndex);
            }
            if (target != null && !target.equals(ourSurrogateId)) {
                newSurrogateControlL.add(StringUtils.strip((String)directiveAndTarget));
                continue;
            }
            if (directive.startsWith("content=\"")) {
                String[] content;
                for (String contentCap : content = StringUtils.split((String)directive.substring("content=\"".length(), directive.length() - 1), (String)" ")) {
                    if (ArrayUtils.contains((Object[])this.capabilities, (Object)(contentCap = StringUtils.strip((String)contentCap)))) {
                        enabledCapabilities.add(contentCap);
                        continue;
                    }
                    remainingCapabilities.add(contentCap);
                }
                if (remainingCapabilities.size() <= 0) continue;
                newSurrogateControlL.add("content=\"" + StringUtils.join(remainingCapabilities, (String)" ") + "\"");
                continue;
            }
            if (directive.startsWith("max-age=")) {
                String[] maxAge = StringUtils.split((String)directive, (String)"+");
                newCacheContent.add(maxAge[0]);
                if (maxAge.length > 1) {
                    newCacheContent.add("stale-while-revalidate=" + maxAge[1]);
                    newCacheContent.add("stale-if-error=" + maxAge[1]);
                }
                newSurrogateControlL.add(directive);
                continue;
            }
            if (directive.startsWith("no-store")) {
                newSurrogateControlL.add(directive);
                newCacheContent.add(directive);
                continue;
            }
            newSurrogateControlL.add(directive);
        }
        e.getHttpResponse().setHeader(H_X_ENABLED_CAPABILITIES, StringUtils.join(enabledCapabilities, (String)" "));
        e.getHttpResponse().setHeader(H_X_NEXT_SURROGATE_CONTROL, StringUtils.join(newSurrogateControlL, (String)", "));
        if (newCacheContent.size() > 0) {
            MoveResponseHeader.moveHeader((HttpResponse)e.getHttpResponse(), "Cache-Control", H_X_ORIGINAL_CACHE_CONTROL);
            e.getHttpResponse().setHeader("Cache-Control", StringUtils.join(newCacheContent, (String)", "));
        }
    }

    private void fixSurrogateMap(LinkedHashMap<String, List<String>> targetCapabilities, String currentSurrogate) {
        boolean esiEnabledInEsigate = false;
        for (String c : Esi.CAPABILITIES) {
            if (!targetCapabilities.get(currentSurrogate).contains(c)) continue;
            esiEnabledInEsigate = true;
            break;
        }
        if (esiEnabledInEsigate) {
            for (String c : Esi.CAPABILITIES) {
                for (String device : targetCapabilities.keySet()) {
                    if (device.equals(currentSurrogate)) {
                        if (targetCapabilities.get(device).contains(c)) continue;
                        targetCapabilities.get(device).add(c);
                        continue;
                    }
                    targetCapabilities.get(device).remove(c);
                }
            }
        }
    }

    private void initSurrogateMap(Map<String, List<String>> targetCapabilities, SurrogateCapabilitiesHeader surrogateCapabilitiesHeader) {
        for (SurrogateCapabilities sc : surrogateCapabilitiesHeader.getSurrogates()) {
            targetCapabilities.put(sc.getDeviceToken(), new ArrayList());
        }
    }

    private String getFirstSurrogateFor(SurrogateCapabilitiesHeader surrogateCapabilitiesHeader, String capability) {
        for (SurrogateCapabilities surrogate : surrogateCapabilitiesHeader.getSurrogates()) {
            for (Capability sc : surrogate.getCapabilities()) {
                if (!capability.equals(sc.toString())) continue;
                return surrogate.getDeviceToken();
            }
        }
        return null;
    }

    private static void processSurrogateControlContent(HttpResponse response, boolean keepHeader) {
        if (!response.containsHeader(H_SURROGATE_CONTROL)) {
            return;
        }
        if (!keepHeader) {
            response.removeHeaders(H_SURROGATE_CONTROL);
            return;
        }
        MoveResponseHeader.moveHeader(response, H_X_NEXT_SURROGATE_CONTROL, H_SURROGATE_CONTROL);
    }
}

