/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.extension.Extension;
import org.esigate.util.Parameter;
import org.esigate.util.ParameterLong;
import org.esigate.vars.VariablesResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigReloadOnChange
implements Extension {
    private static final long DEFAULT_RELOAD_DELAY = 5000L;
    public static final Parameter<Long> CONFIG_RELOAD_DELAY;
    private static final int SPEED_LIMIT = 100;
    protected static final Logger LOG;
    private static File configuration;
    private static File variables;
    private static long configLastModified;
    private static long varsLastModified;
    private static long delay;
    private static boolean stop;
    private static Thread fileWatcher;

    @Override
    public void init(Driver driver, Properties properties) {
        if (configuration == null) {
            LOG.warn("Cannot reload configuration from classpath. Please use -Desigate.config");
            return;
        }
        try {
            delay = CONFIG_RELOAD_DELAY.getValue(properties);
            if (delay < 100L) {
                delay = 100L;
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to convert {}={} as number", (Object)CONFIG_RELOAD_DELAY.getName(), (Object)e);
        }
        LOG.info("Will reload configuration every {}ms if {} is modified", (Object)delay, (Object)configuration.getAbsoluteFile());
    }

    static {
        URL variablesUrl;
        CONFIG_RELOAD_DELAY = new ParameterLong("configReloadDelay", 5000L);
        LOG = LoggerFactory.getLogger(ConfigReloadOnChange.class);
        configuration = null;
        variables = null;
        configLastModified = -1L;
        varsLastModified = -1L;
        delay = 5000L;
        stop = false;
        fileWatcher = new Thread(){

            @Override
            public void run() {
                while (!stop) {
                    if (configuration != null && configuration.exists() && configuration.lastModified() != configLastModified) {
                        configLastModified = configuration.lastModified();
                        LOG.warn("Configuration file changed : reloading.");
                        DriverFactory.configure();
                    }
                    if (variables != null && variables.exists() && variables.lastModified() != varsLastModified) {
                        varsLastModified = variables.lastModified();
                        LOG.warn("Variables file changed : reloading.");
                        VariablesResolver.configure();
                    }
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        stop = true;
                        LOG.warn("Watching interrupted.");
                    }
                }
                LOG.info("Stopped watching {}.", (Object)configuration.getAbsoluteFile());
            }
        };
        String envPath = System.getProperty("esigate.config");
        if (envPath != null) {
            configuration = new File(envPath);
        } else {
            URL configUrl = DriverFactory.getConfigUrl();
            if (configUrl != null && "file".equalsIgnoreCase(configUrl.getProtocol())) {
                try {
                    configuration = new File(configUrl.toURI());
                }
                catch (URISyntaxException e) {
                    LOG.error("Unable to access configuration file", (Throwable)e);
                }
            }
        }
        if (configuration != null && configuration.exists()) {
            configLastModified = configuration.lastModified();
        }
        if ((variablesUrl = VariablesResolver.getVariablessUrl()) != null && "file".equalsIgnoreCase(variablesUrl.getProtocol())) {
            try {
                variables = new File(variablesUrl.toURI());
            }
            catch (URISyntaxException e) {
                LOG.error("Unable to access variables file", (Throwable)e);
            }
        }
        if (variables != null && variables.exists()) {
            varsLastModified = variables.lastModified();
        }
        fileWatcher.start();
    }
}

