/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.esi;

import java.io.IOException;
import org.esigate.esi.BaseElement;
import org.esigate.esi.BaseElementType;
import org.esigate.esi.EsiRenderer;
import org.esigate.esi.Tag;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContext;

class FragmentElement
extends BaseElement {
    public static final ElementType TYPE = new BaseElementType("<esi:fragment", "</esi:fragment"){

        @Override
        public FragmentElement newInstance() {
            return new FragmentElement();
        }
    };
    private EsiRenderer esiRenderer;
    private boolean nameMatches;
    private CharSequence replacement = null;
    private boolean initialStateWrite = false;

    FragmentElement() {
    }

    @Override
    public void onTagEnd(String tag, ParserContext ctx) throws IOException {
        if (this.replacement != null) {
            this.esiRenderer.setWrite(true);
            this.characters(this.replacement, 0, this.replacement.length());
        }
        this.esiRenderer.setWrite(this.initialStateWrite);
    }

    @Override
    protected void parseTag(Tag tag, ParserContext ctx) {
        String name = tag.getAttribute("name");
        this.esiRenderer = ctx.findAncestor(EsiRenderer.class);
        this.initialStateWrite = this.esiRenderer.isWrite();
        if (this.esiRenderer != null) {
            this.nameMatches = name.equals(this.esiRenderer.getName());
            if (this.nameMatches) {
                this.esiRenderer.setWrite(true);
                this.esiRenderer.setFound(true);
            } else if (this.esiRenderer.getFragmentsToReplace() != null && this.initialStateWrite) {
                this.replacement = this.esiRenderer.getFragmentsToReplace().get(name);
                if (this.replacement != null) {
                    this.esiRenderer.setWrite(false);
                }
            }
        }
    }
}

