/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;

public final class UriUtils {
    private UriUtils() {
    }

    public static String createURI(String scheme, String host, int port, String path, String query, String fragment) {
        StringBuilder buffer = new StringBuilder(256);
        if (host != null) {
            if (scheme != null) {
                buffer.append(scheme);
                buffer.append("://");
            }
            buffer.append(host);
            if (port > 0) {
                buffer.append(':');
                buffer.append(port);
            }
        }
        if (path == null || !path.startsWith("/")) {
            buffer.append('/');
        }
        if (path != null) {
            buffer.append(path);
        }
        if (query != null) {
            buffer.append('?');
            buffer.append(query);
        }
        if (fragment != null) {
            buffer.append('#');
            buffer.append(fragment);
        }
        return buffer.toString();
    }

    public static String extractHostName(String uri) {
        return UriUtils.extractHost(uri).getHostName();
    }

    public static HttpHost extractHost(String uri) {
        return URIUtils.extractHost((URI)UriUtils.createUri(uri));
    }

    private static URI createUri(String uri) {
        return URI.create(uri);
    }

    public static String rewriteURI(String uri, HttpHost targetHost) {
        try {
            return URIUtils.rewriteURI((URI)UriUtils.createUri(uri), (HttpHost)targetHost).toString();
        }
        catch (URISyntaxException e) {
            throw new InvalidUriException(e);
        }
    }

    public static String removeSessionId(String sessionId, String page) {
        String regexp = ";?jsessionid=" + Pattern.quote(sessionId);
        return page.replaceAll(regexp, "");
    }

    public static String extractScheme(String uri) {
        return UriUtils.extractHost(uri).getSchemeName();
    }

    public static String translateUrl(String sourceUrl, String sourceContext, String targetContext) {
        String commonSuffix = StringUtils.reverse((String)StringUtils.getCommonPrefix((String[])new String[]{StringUtils.reverse((String)sourceContext), StringUtils.reverse((String)targetContext)}));
        String sourcePrefix = StringUtils.removeEnd((String)sourceContext, (String)commonSuffix);
        HttpHost sourceHost = UriUtils.extractHost(sourcePrefix);
        String targetPrefix = StringUtils.removeEnd((String)targetContext, (String)commonSuffix);
        String absoluteSourceUrl = UriUtils.isAbsolute(sourceUrl) ? sourceUrl : URIUtils.resolve((URI)UriUtils.createUri(sourceContext), (String)sourceUrl).toString();
        if (UriUtils.extractHost(absoluteSourceUrl).equals((Object)sourceHost) && absoluteSourceUrl.startsWith(sourcePrefix)) {
            return targetPrefix + StringUtils.removeStart((String)absoluteSourceUrl, (String)sourcePrefix);
        }
        return absoluteSourceUrl;
    }

    public static String getRawQuery(String uri) {
        return UriUtils.createUri(uri).getRawQuery();
    }

    public static String getPath(String uri) {
        return UriUtils.createUri(uri).getPath();
    }

    public static List<NameValuePair> parse(String uri, String charset) {
        return URLEncodedUtils.parse((URI)UriUtils.createUri(uri), (String)charset);
    }

    public static boolean isAbsolute(String uri) {
        return uri.startsWith("http://") || uri.startsWith("https://");
    }

    private static final class InvalidUriException
    extends RuntimeException {
        private static final long serialVersionUID = 7013885420191182730L;

        private InvalidUriException(URISyntaxException cause) {
            super(cause);
        }
    }
}

