/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.esigate.ConfigurationException;

public final class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static Collection<String> getPropertyValue(Properties properties, String propertyName, Collection<String> defaultValue) {
        Collection<String> result = defaultValue;
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue != null && (result = PropertiesUtil.toCollection(propertyValue)).contains("*") && result.size() > 1) {
            throw new ConfigurationException(propertyName + " must be a comma-separated list or *");
        }
        return result;
    }

    static Collection<String> toCollection(String list) {
        ArrayList<String> result = new ArrayList<String>();
        if (list != null) {
            String[] values;
            for (String value : values = list.split(",")) {
                String trimmed = value.trim();
                if (trimmed.isEmpty()) continue;
                result.add(trimmed);
            }
        }
        return result;
    }

    public static int getPropertyValue(Properties props, String name, int defaultValue) {
        String value = props.getProperty(name);
        int result = defaultValue;
        if (value != null) {
            result = Integer.parseInt(value);
        }
        return result;
    }

    public static boolean getPropertyValue(Properties props, String name, boolean defaultValue) {
        String value = props.getProperty(name);
        boolean result = defaultValue;
        if (value != null) {
            result = Boolean.parseBoolean(value);
        }
        return result;
    }

    public static String getPropertyValue(Properties props, String name, String defaultValue) {
        return props.getProperty(name, defaultValue);
    }

    public static float getPropertyValue(Properties properties, String name, float defaultValue) {
        String value = properties.getProperty(name);
        float result = defaultValue;
        if (value != null) {
            result = Float.parseFloat(value);
        }
        return result;
    }

    public static long getPropertyValue(Properties properties, String name, long defaultValue) {
        String value = properties.getProperty(name);
        long result = defaultValue;
        if (value != null) {
            result = Long.parseLong(value);
        }
        return result;
    }
}

