/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.test.driver;

import java.io.IOException;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.HttpClientConnectionManager;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.http.HttpClientRequestExecutor;
import org.esigate.http.IncomingRequest;
import org.esigate.test.TestUtils;
import org.esigate.test.conn.IResponseHandler;
import org.esigate.test.conn.MockConnectionManager;
import org.esigate.test.http.HttpResponseBuilder;
import org.esigate.util.UriUtils;

public abstract class AbstractDriverTestCase
extends TestCase {
    protected static Driver createMockDriver(Properties properties, IResponseHandler responseHandler) {
        MockConnectionManager connManager = new MockConnectionManager();
        connManager.setResponseHandler(responseHandler);
        return AbstractDriverTestCase.createMockDriver(properties, connManager);
    }

    protected static Driver createMockDriver(Properties properties, HttpResponse response) {
        MockConnectionManager connManager = new MockConnectionManager();
        connManager.setResponse(response);
        return AbstractDriverTestCase.createMockDriver(properties, connManager);
    }

    protected static Driver createMockDriver(Properties properties, HttpClientConnectionManager connectionManager) {
        return AbstractDriverTestCase.createMockDriver(properties, connectionManager, "tested");
    }

    protected static Driver createMockDriver(Properties properties, HttpClientConnectionManager connectionManager, String name) {
        Driver driver = Driver.builder().setName(name).setProperties(properties).setRequestExecutorBuilder(HttpClientRequestExecutor.builder().setConnectionManager(connectionManager)).build();
        DriverFactory.put(name, driver);
        return driver;
    }

    public static HttpResponseBuilder createHttpResponse() {
        return new HttpResponseBuilder();
    }

    public static IncomingRequest.Builder createRequest(String uri) {
        return TestUtils.createIncomingRequest(uri);
    }

    public static CloseableHttpResponse driverProxy(Driver d, IncomingRequest request, Renderer ... renderers) throws IOException, HttpErrorPage {
        String uri = request.getRequestLine().getUri();
        return d.proxy(UriUtils.getPath(uri), request, renderers);
    }
}

