/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.test.conn;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;
import org.esigate.HttpErrorPage;
import org.esigate.test.conn.IResponseHandler;

public class MockConnectionManager
implements HttpClientConnectionManager {
    private final AtomicBoolean open = new AtomicBoolean(false);
    private IResponseHandler responseHandler;
    private HttpRequest sentRequest;
    private long sleep = 0L;
    private final ConnectionRequest connectionRequest = new ConnectionRequest(){

        public boolean cancel() {
            return false;
        }

        public HttpClientConnection get(long timeout, TimeUnit tunit) {
            if (MockConnectionManager.this.open.get()) {
                throw new IllegalStateException("Connection is busy");
            }
            return MockConnectionManager.this.httpClientConnection;
        }
    };
    private final HttpClientConnection httpClientConnection = new HttpClientConnection(){

        public void shutdown() {
            MockConnectionManager.this.open.set(false);
        }

        public void setSocketTimeout(int timeout) {
        }

        public boolean isStale() {
            return !MockConnectionManager.this.open.get();
        }

        public boolean isOpen() {
            return MockConnectionManager.this.open.get();
        }

        public int getSocketTimeout() {
            return 0;
        }

        public HttpConnectionMetrics getMetrics() {
            return null;
        }

        public void close() {
            MockConnectionManager.this.open.set(false);
        }

        public void sendRequestHeader(HttpRequest request) {
            MockConnectionManager.this.sentRequest = request;
        }

        public void sendRequestEntity(HttpEntityEnclosingRequest request) {
            MockConnectionManager.this.sentRequest = (HttpRequest)request;
        }

        public HttpResponse receiveResponseHeader() {
            MockConnectionManager.this.sleep();
            return MockConnectionManager.this.execute(MockConnectionManager.this.sentRequest);
        }

        public void receiveResponseEntity(HttpResponse response) {
        }

        public boolean isResponseAvailable(int timeout) {
            return true;
        }

        public void flush() {
        }
    };

    private void sleep() {
        if (this.sleep > 0L) {
            try {
                Thread.sleep(this.sleep);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ConnectionRequest requestConnection(HttpRoute route, Object state) {
        return this.connectionRequest;
    }

    public void releaseConnection(HttpClientConnection conn, Object newState, long validDuration, TimeUnit timeUnit) {
        this.open.set(false);
    }

    public void closeIdleConnections(long idletime, TimeUnit tunit) {
    }

    public void closeExpiredConnections() {
    }

    public void shutdown() {
        this.open.set(false);
    }

    public HttpRequest getSentRequest() {
        return this.sentRequest;
    }

    public void setResponse(final HttpResponse response) {
        this.setResponseHandler(new IResponseHandler(){

            @Override
            public HttpResponse execute(HttpRequest request) {
                return response;
            }
        });
    }

    public void setResponseHandler(IResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    public HttpResponse execute(HttpRequest request) {
        try {
            return this.responseHandler.execute(request);
        }
        catch (IOException e) {
            return HttpErrorPage.generateHttpResponse(e);
        }
    }

    public final boolean isOpen() {
        return this.open.get();
    }

    public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) {
    }

    public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) {
    }

    public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) {
    }
}

