/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.esigate.ConfigurationException;

public final class UriMapping {
    private static final Pattern MAPPING_PATTERN = Pattern.compile("((http://|https://)[^/:]*(:([0-9]*))?)?(/[^*]*)?(\\*?)([^*]*)");
    private final String host;
    private final String path;
    private final String extension;
    private final int weight;

    private UriMapping(String host, String path, String extension) {
        this.host = host;
        this.path = path;
        this.extension = extension;
        int targetWeight = 0;
        if (this.host != null) {
            targetWeight += 1000;
        }
        if (this.path != null) {
            targetWeight += this.path.length() * 10;
        }
        if (this.extension != null) {
            targetWeight += this.extension.length();
        }
        this.weight = targetWeight;
    }

    public static UriMapping create(String mapping) {
        Matcher matcher = MAPPING_PATTERN.matcher(mapping);
        if (!matcher.matches()) {
            throw new ConfigurationException("Unrecognized URI pattern: " + mapping);
        }
        String host = StringUtils.trimToNull((String)matcher.group(1));
        String path = StringUtils.trimToNull((String)matcher.group(5));
        if (path != null && !path.startsWith("/")) {
            throw new ConfigurationException("Unrecognized URI pattern: " + mapping + " Mapping path should start with / was: " + path);
        }
        String extension = StringUtils.trimToNull((String)matcher.group(7));
        if (extension != null && !extension.startsWith(".")) {
            throw new ConfigurationException("Unrecognized URI pattern: " + mapping + " Mapping extension should start with . was: " + extension);
        }
        return new UriMapping(host, path, extension);
    }

    public boolean matches(String schemeParam, String hostParam, String uriParam) {
        if (this.host != null && !this.host.equalsIgnoreCase(schemeParam + "://" + hostParam)) {
            return false;
        }
        if (this.extension != null && !uriParam.endsWith(this.extension)) {
            return false;
        }
        return this.path == null || uriParam.startsWith(this.path);
    }

    public int getWeight() {
        return this.weight;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getPath() {
        return this.path;
    }

    public String getHost() {
        return this.host;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

