/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import org.apache.http.HttpHost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.esigate.http.OutgoingRequest;

public class OutgoingRequestContext
extends HttpClientContext {
    private static final String PROXY = "PROXY";
    private static final String OUTGOING_REQUEST = "OUTGOING_REQUEST";
    private static final String PHYSICAL_HOST = "PHYSICAL_HOST";

    public static OutgoingRequestContext adapt(HttpContext context) {
        if (context instanceof OutgoingRequestContext) {
            return (OutgoingRequestContext)context;
        }
        return new OutgoingRequestContext(context);
    }

    private OutgoingRequestContext(HttpContext context) {
        super(context);
    }

    public OutgoingRequestContext() {
    }

    public boolean isProxy() {
        Boolean proxy = (Boolean)this.getAttribute(PROXY, Boolean.class);
        if (proxy == null) {
            return false;
        }
        return proxy;
    }

    public void setProxy(boolean proxy) {
        this.setAttribute(PROXY, proxy);
    }

    public OutgoingRequest getOutgoingRequest() {
        return (OutgoingRequest)((Object)this.getAttribute(OUTGOING_REQUEST, OutgoingRequest.class));
    }

    public void setOutgoingRequest(OutgoingRequest outgoingRequest) {
        this.setAttribute(OUTGOING_REQUEST, (Object)outgoingRequest);
    }

    public HttpHost getPhysicalHost() {
        return (HttpHost)this.getAttribute(PHYSICAL_HOST, HttpHost.class);
    }

    public void setPhysicalHost(HttpHost httpHost) {
        this.setAttribute(PHYSICAL_HOST, httpHost);
    }
}

