/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicRequestLine;
import org.esigate.api.ContainerRequestContext;
import org.esigate.api.Session;

public final class IncomingRequest
extends BasicHttpEntityEnclosingRequest {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private ContainerRequestContext context;
    private String remoteUser;
    private String remoteAddr;
    private String sessionId;
    private Principal userPrincipal;
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private List<Cookie> newCookies = new ArrayList<Cookie>();
    private Session session;

    public static Builder builder(RequestLine requestline) {
        return new Builder(requestline);
    }

    public static Builder builder(String uri) {
        return new Builder((RequestLine)new BasicRequestLine("GET", uri, (ProtocolVersion)HttpVersion.HTTP_1_1));
    }

    private IncomingRequest(RequestLine requestline) {
        super(requestline);
    }

    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public ContainerRequestContext getContext() {
        return this.context;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public Cookie[] getNewCookies() {
        return this.newCookies.toArray(new Cookie[this.newCookies.size()]);
    }

    public void addNewCookie(Cookie cookie) {
        this.newCookies.add(cookie);
    }

    public Session getSession() {
        return this.session;
    }

    public static final class Builder {
        private final IncomingRequest result;

        private Builder(RequestLine requestline) {
            this.result = new IncomingRequest(requestline);
        }

        public IncomingRequest build() {
            return this.result;
        }

        public Builder setContext(ContainerRequestContext context) {
            this.result.context = context;
            return this;
        }

        public Builder setRemoteAddr(String remoteAddr) {
            this.result.remoteAddr = remoteAddr;
            return this;
        }

        public Builder setRemoteUser(String remoteUser) {
            this.result.remoteUser = remoteUser;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.result.sessionId = sessionId;
            return this;
        }

        public Builder setUserPrincipal(Principal userPrincipal) {
            this.result.userPrincipal = userPrincipal;
            return this;
        }

        public Builder addCookie(Cookie cookie) {
            this.result.cookies.add(cookie);
            return this;
        }

        public Builder setSession(Session session) {
            this.result.session = session;
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.result.addHeader(name, value);
            return this;
        }

        public Builder setEntity(InputStreamEntity entity) {
            this.result.setEntity((HttpEntity)entity);
            return this;
        }
    }
}

