/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.ProxyEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteResponseHeader
implements IEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteResponseHeader.class);
    private final String name;

    public DeleteResponseHeader(String name) {
        this.name = name;
    }

    @Override
    public boolean event(EventDefinition id, Event event) {
        ProxyEvent fEvent = (ProxyEvent)event;
        if (fEvent.getResponse() != null && fEvent.getResponse().containsHeader(this.name)) {
            LOG.info("Deleting header {} ", (Object)this.name);
            fEvent.getResponse().removeHeaders(this.name);
        }
        if (fEvent.getErrorPage() != null && fEvent.getErrorPage().getHttpResponse() != null && fEvent.getErrorPage().getHttpResponse().containsHeader(this.name)) {
            LOG.info("Deleting header {} ", (Object)this.name);
            fEvent.getErrorPage().getHttpResponse().removeHeaders(this.name);
        }
        return true;
    }
}

