/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.esi;

import org.esigate.HttpErrorPage;
import org.esigate.esi.BaseElement;
import org.esigate.esi.BaseElementType;
import org.esigate.esi.EsiSyntaxError;
import org.esigate.esi.IncludeElement;
import org.esigate.esi.Tag;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContext;
import org.esigate.vars.VariablesResolver;

class ReplaceElement
extends BaseElement {
    public static final ElementType TYPE = new BaseElementType("<esi:replace", "</esi:replace"){

        @Override
        public ReplaceElement newInstance() {
            return new ReplaceElement();
        }
    };
    private StringBuilder buf = null;
    private String fragment;
    private String regexp;

    ReplaceElement() {
    }

    @Override
    public void characters(CharSequence csq, int start, int end) {
        this.buf.append(csq, start, end);
    }

    @Override
    public void onTagEnd(String tag, ParserContext ctx) throws HttpErrorPage {
        IncludeElement parent = ctx.findAncestor(IncludeElement.class);
        if (parent == null) {
            throw new EsiSyntaxError("<esi:replace> tag can only be used inside an <esi:include> tag");
        }
        String result = VariablesResolver.replaceAllVariables(this.buf.toString(), ctx.getHttpRequest());
        if (this.fragment != null) {
            parent.addFragmentReplacement(this.fragment, result);
        } else if (this.regexp != null) {
            parent.addRegexpReplacement(this.regexp, result);
        } else {
            parent.characters(result, 0, result.length());
        }
    }

    @Override
    protected void parseTag(Tag tag, ParserContext ctx) throws HttpErrorPage {
        this.buf = new StringBuilder(1024);
        this.fragment = tag.getAttribute("fragment");
        this.regexp = tag.getAttribute("regexp");
        if (this.regexp == null) {
            this.regexp = tag.getAttribute("expression");
        }
        if (this.fragment == null && this.regexp == null || this.fragment != null && this.regexp != null) {
            throw new EsiSyntaxError("only one of 'fragment' and 'expression' attributes is allowed");
        }
    }
}

