/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.authentication;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.esigate.authentication.GenericAuthentificationHandler;
import org.esigate.http.IncomingRequest;
import org.esigate.http.OutgoingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestAuthenticationHandler
extends GenericAuthentificationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RequestAuthenticationHandler.class);
    private final List<String> sessionAttributes = new ArrayList<String>();
    private final List<String> requestAttributes = new ArrayList<String>();
    private String headerPrefix = "X-ATTR-";

    @Override
    public boolean beforeProxy(HttpRequest httpRequest) {
        return true;
    }

    @Override
    public void init(Properties properties) {
        String headerPrefixProperty;
        String requestAttributesProperty;
        String sessionAttributesProperty = properties.getProperty("forwardSessionAttributes");
        if (sessionAttributesProperty != null) {
            String[] attributes;
            for (String attribute : attributes = sessionAttributesProperty.split(",")) {
                this.sessionAttributes.add(attribute.trim());
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Forwading session attribute: " + attribute);
            }
        }
        if ((requestAttributesProperty = (String)properties.get("forwardRequestAttributes")) != null) {
            String[] attributes;
            for (String attribute : attributes = requestAttributesProperty.split(",")) {
                this.requestAttributes.add(attribute.trim());
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Forwading request attribute: " + attribute);
            }
        }
        if ((headerPrefixProperty = (String)properties.get("headerPrefix")) != null) {
            this.headerPrefix = headerPrefixProperty;
        }
    }

    @Override
    public boolean needsNewRequest(HttpResponse response, OutgoingRequest outgoingRequest, IncomingRequest incomingRequest) {
        return false;
    }

    @Override
    public void preRequest(OutgoingRequest request, IncomingRequest httpRequest) {
        String value;
        LOG.debug("preRequest");
        for (String attribute : this.sessionAttributes) {
            value = (String)((Object)httpRequest.getSession().getAttribute(attribute));
            if (value == null) continue;
            LOG.debug("Adding session attribute {} ({}) as header ({}{})", new Object[]{attribute, value, this.headerPrefix, attribute});
            request.addHeader(this.headerPrefix + attribute, value);
        }
        for (String attribute : this.requestAttributes) {
            value = (String)httpRequest.getAttribute(attribute);
            if (value == null) continue;
            LOG.debug("Adding request attribute {} ({}) as header ({}{})", new Object[]{attribute, value, this.headerPrefix, attribute});
            request.addHeader(this.headerPrefix + attribute, value);
        }
    }
}

