/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.esigate.ConfigurationException;

public final class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static Collection<String> getPropertyValueAsList(Properties properties, String propertyName, String defaultValue) {
        Collection<String> result;
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null) {
            propertyValue = defaultValue;
        }
        if ((result = PropertiesUtil.toCollection(propertyValue)).contains("*") && result.size() > 1) {
            throw new ConfigurationException(propertyName + " must be a comma-separated list or *");
        }
        return result;
    }

    static Collection<String> toCollection(String list) {
        ArrayList<String> result = new ArrayList<String>();
        if (list != null) {
            String[] values;
            for (String value : values = list.split(",")) {
                String trimmed = value.trim();
                if (trimmed.isEmpty()) continue;
                result.add(trimmed);
            }
        }
        return result;
    }

    public static int getPropertyValue(Properties props, String name, int defaultValue) {
        String value = props.getProperty(name);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public static boolean getPropertyValue(Properties props, String name, boolean defaultValue) {
        String value = props.getProperty(name);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public static String getPropertyValue(Properties props, String name, String defaultValue) {
        return props.getProperty(name, defaultValue);
    }

    public static float getPropertyValue(Properties properties, String name, float defaultValue) {
        String value = properties.getProperty(name);
        return value != null ? Float.parseFloat(value) : defaultValue;
    }

    public static long getPropertyValue(Properties properties, String name, long defaultValue) {
        String value = properties.getProperty(name);
        return value != null ? Long.parseLong(value) : defaultValue;
    }
}

