/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.util;

import java.util.Collection;
import java.util.Properties;
import org.esigate.util.PropertiesUtil;

public final class Parameter {
    private final String name;
    private final String defaultValue;

    public boolean equals(Object obj) {
        return this.name.equals(obj);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Parameter(String name, String defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public int getValueInt(Properties properties) {
        int defaultValueInt = 0;
        if (this.defaultValue != null) {
            defaultValueInt = Integer.parseInt(this.defaultValue);
        }
        return PropertiesUtil.getPropertyValue(properties, this.name, defaultValueInt);
    }

    public boolean getValueBoolean(Properties properties) {
        boolean defaultValueBoolean = false;
        if (this.defaultValue != null) {
            defaultValueBoolean = Boolean.parseBoolean(this.defaultValue);
        }
        return PropertiesUtil.getPropertyValue(properties, this.name, defaultValueBoolean);
    }

    public float getValueFloat(Properties properties) {
        float defaultValueFloat = 0.0f;
        if (this.defaultValue != null) {
            defaultValueFloat = Float.parseFloat(this.defaultValue);
        }
        return PropertiesUtil.getPropertyValue(properties, this.name, defaultValueFloat);
    }

    public long getValueLong(Properties properties) {
        long defaultValueLong = 0L;
        if (this.defaultValue != null) {
            defaultValueLong = Long.parseLong(this.defaultValue);
        }
        return PropertiesUtil.getPropertyValue(properties, this.name, defaultValueLong);
    }

    public String getValueString(Properties properties) {
        return PropertiesUtil.getPropertyValue(properties, this.name, this.defaultValue);
    }

    public Collection<String> getValueList(Properties properties) {
        return PropertiesUtil.getPropertyValueAsList(properties, this.name, this.defaultValue);
    }

    public String[] getValueArray(Properties properties) {
        Collection<String> resultAsCollection = this.getValueList(properties);
        return resultAsCollection.toArray(new String[resultAsCollection.size()]);
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

