/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.regexp;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;
import org.esigate.Renderer;
import org.esigate.impl.DriverRequest;

public class ReplaceRenderer
implements Renderer {
    private final Map<String, String> replaceRules;

    public ReplaceRenderer(Map<String, String> replaceRules) {
        this.replaceRules = replaceRules;
    }

    @Override
    public void render(DriverRequest httpRequest, String src, Writer out) throws IOException {
        out.write(this.replace(src, this.replaceRules).toString());
    }

    private CharSequence replace(CharSequence charSequence, Map<String, String> replaceRules) {
        CharSequence result = charSequence;
        if (replaceRules != null && replaceRules.size() > 0) {
            for (Map.Entry<String, String> replaceRule : replaceRules.entrySet()) {
                result = Pattern.compile(replaceRule.getKey()).matcher(result).replaceAll(replaceRule.getValue());
            }
        }
        return result;
    }
}

