/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.parser.future;

import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Future;
import org.apache.http.HttpResponse;
import org.esigate.HttpErrorPage;
import org.esigate.impl.DriverRequest;
import org.esigate.parser.future.FutureAppendable;
import org.esigate.parser.future.FutureElement;
import org.esigate.parser.future.FutureElementType;
import org.esigate.parser.future.FutureParserContext;

class FutureParserContextImpl
implements FutureParserContext {
    private final RootAdapter root;
    private final DriverRequest httpRequest;
    private final HttpResponse httpResponse;
    private final Stack<Pair> stack = new Stack();
    private Map<String, Object> data;

    FutureParserContextImpl(FutureAppendable root, DriverRequest httpRequest, HttpResponse httpResponse, Map<String, Object> data) {
        this.root = new RootAdapter(root);
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.data = data;
    }

    @Override
    public <T> T findAncestor(Class<T> type) {
        T result = null;
        for (int i = this.stack.size() - 1; i > -1; --i) {
            FutureElement currentElement = ((Pair)this.stack.elementAt(i)).element;
            if (!type.isInstance(currentElement)) continue;
            result = type.cast(currentElement);
            break;
        }
        if (result == null && type.isInstance(this.root.root)) {
            result = type.cast(this.root.root);
        }
        return result;
    }

    @Override
    public boolean reportError(FutureElement el, Exception e) {
        boolean result = false;
        for (FutureElement current = el.getParent(); current != null; current = current.getParent()) {
            if (!current.onError(e, this)) continue;
            result = true;
            break;
        }
        return result;
    }

    void startElement(FutureElementType type, FutureElement element, String tag) throws IOException, HttpErrorPage {
        element.onTagStart(tag, this);
        this.stack.push(new Pair(type, element));
    }

    void endElement(String tag) throws IOException, HttpErrorPage {
        FutureElement element = this.stack.pop().element;
        element.onTagEnd(tag, this);
    }

    boolean isCurrentTagEnd(String tag) {
        return !this.stack.isEmpty() && this.stack.peek().type.isEndTag(tag);
    }

    void characters(Future<CharSequence> csq) throws IOException {
        this.getCurrent().characters(csq);
    }

    @Override
    public FutureElement getCurrent() {
        return !this.stack.isEmpty() ? this.stack.peek().element : this.root;
    }

    @Override
    public DriverRequest getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    @Override
    public Object getData(String key) {
        return this.data == null ? null : this.data.get(key);
    }

    private static class RootAdapter
    implements FutureElement {
        private final FutureAppendable root;

        public RootAdapter(FutureAppendable root) {
            this.root = root;
        }

        @Override
        public void onTagStart(String tag, FutureParserContext ctx) {
        }

        @Override
        public void onTagEnd(String tag, FutureParserContext ctx) {
        }

        @Override
        public boolean onError(Exception e, FutureParserContext ctx) {
            return false;
        }

        @Override
        public void characters(Future<CharSequence> csq) throws IOException {
            this.root.enqueueAppend(csq);
        }

        @Override
        public boolean isClosed() {
            return false;
        }

        @Override
        public FutureElement getParent() {
            return null;
        }
    }

    private static class Pair {
        private final FutureElementType type;
        private final FutureElement element;

        public Pair(FutureElementType type2, FutureElement element) {
            this.type = type2;
            this.element = element;
        }
    }
}

