/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.impl;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.esigate.Parameters;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UrlRewriter {
    private static final Logger LOG = LoggerFactory.getLogger(UrlRewriter.class);
    public static final int ABSOLUTE = 0;
    public static final int RELATIVE = 1;
    private static final Pattern URL_PATTERN = Pattern.compile("<([^\\!][^>]+)(src|href|action|background)\\s*=\\s*('[^<']*'|\"[^<\"]*\")([^>]*)>", 2);
    private String visibleBaseUrlParameter;
    private int mode;

    public UrlRewriter(Properties properties) {
        this.mode = "absolute".equalsIgnoreCase(Parameters.FIX_MODE.getValueString(properties)) ? 0 : 1;
        this.visibleBaseUrlParameter = StringUtils.stripEnd((String)Parameters.VISIBLE_URL_BASE.getValueString(properties), (String)"/");
    }

    private String concatUrl(String begin, String end) {
        return StringUtils.stripEnd((String)begin, (String)"/") + "/" + StringUtils.stripStart((String)end, (String)"/");
    }

    public String rewriteUrl(String url, String requestUrl, String baseUrl) {
        int indexSlash;
        String visibleBaseUrlPath;
        String pagePath;
        if (url.isEmpty()) {
            LOG.debug("skip empty url");
            return url;
        }
        String fileName = null;
        if (!requestUrl.isEmpty() && !requestUrl.endsWith("/")) {
            fileName = requestUrl.substring(requestUrl.lastIndexOf(47) + 1);
        }
        String cleanBaseUrl = StringUtils.stripEnd((String)baseUrl, (String)"/");
        String visibleBaseUrl = this.visibleBaseUrlParameter;
        if (visibleBaseUrl == null) {
            visibleBaseUrl = cleanBaseUrl;
        }
        if ((pagePath = this.concatUrl(visibleBaseUrlPath = UriUtils.getPath(visibleBaseUrl), requestUrl)) != null && (indexSlash = pagePath.lastIndexOf(47)) >= 0) {
            pagePath = pagePath.substring(0, indexSlash);
        }
        String result = url;
        if (visibleBaseUrl != null && result.startsWith(cleanBaseUrl)) {
            result = visibleBaseUrl + result.substring(cleanBaseUrl.length());
            LOG.debug("fix absolute url: {} -> {} ", (Object)url, (Object)result);
            return result;
        }
        if (result.startsWith("http://") || result.startsWith("https://") || result.startsWith("//") || result.startsWith("#") || result.startsWith("javascript:")) {
            LOG.debug("keeping absolute url: {}", (Object)result);
            return result;
        }
        HttpHost httpHost = UriUtils.extractHost(visibleBaseUrl);
        String server = httpHost.toURI();
        if (result.startsWith("/")) {
            String baseUrlPath;
            if (cleanBaseUrl != null && !cleanBaseUrl.equals(visibleBaseUrl) && result.startsWith(baseUrlPath = UriUtils.getPath(cleanBaseUrl))) {
                result = result.substring(baseUrlPath.length());
                result = this.concatUrl(visibleBaseUrlPath, result);
            }
            if (this.mode == 0) {
                result = server + result;
            }
        } else {
            if (result.charAt(0) == '?' && fileName != null) {
                result = fileName + result;
            }
            result = this.mode == 0 ? server + pagePath + "/" + result : pagePath + "/" + result;
        }
        LOG.debug("url fixed: {} -> {}", (Object)url, (Object)result);
        return result;
    }

    public CharSequence rewriteHtml(CharSequence input, String requestUrl, String baseUrlParam) {
        StringBuffer result = new StringBuffer(input.length());
        Matcher m = URL_PATTERN.matcher(input);
        while (m.find()) {
            LOG.trace("found match: {}", (Object)m);
            String url = input.subSequence(m.start(3) + 1, m.end(3) - 1).toString();
            url = this.rewriteUrl(url, requestUrl, baseUrlParam);
            url = url.replaceAll("\\$", "\\\\\\$");
            StringBuffer tagReplacement = new StringBuffer("<$1$2=\"").append(url).append("\"");
            if (m.groupCount() > 3) {
                tagReplacement.append("$4");
            }
            tagReplacement.append('>');
            LOG.trace("replacement: {}", (Object)tagReplacement);
            m.appendReplacement(result, tagReplacement.toString());
        }
        m.appendTail(result);
        return result;
    }
}

