/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.params.HttpParams;
import org.esigate.Driver;
import org.esigate.HttpErrorPage;
import org.esigate.UserContext;
import org.esigate.api.ContainerRequestContext;
import org.esigate.http.IncomingRequest;

public class DriverRequest
implements HttpEntityEnclosingRequest {
    private final IncomingRequest wrappedRequest;
    private final Driver driver;
    private final UserContext userContext;
    private final URL baseUrl;
    private final boolean external;
    private String characterEncoding;

    public DriverRequest(IncomingRequest request, Driver driver, boolean external) throws HttpErrorPage {
        this.wrappedRequest = request;
        this.driver = driver;
        this.external = external;
        this.userContext = new UserContext(request, driver.getConfiguration().getInstanceName());
        try {
            this.baseUrl = new URL(driver.getConfiguration().getBaseUrlRetrieveStrategy().getBaseURL(request));
        }
        catch (MalformedURLException e) {
            throw new HttpErrorPage(500, "Internal server error", e);
        }
    }

    public boolean expectContinue() {
        return this.wrappedRequest.expectContinue();
    }

    public void setEntity(HttpEntity entity) {
        this.wrappedRequest.setEntity(entity);
    }

    public RequestLine getRequestLine() {
        return this.wrappedRequest.getRequestLine();
    }

    public HttpEntity getEntity() {
        return this.wrappedRequest.getEntity();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.wrappedRequest.getProtocolVersion();
    }

    public boolean containsHeader(String name) {
        return this.wrappedRequest.containsHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.wrappedRequest.getHeaders(name);
    }

    public Header getFirstHeader(String name) {
        return this.wrappedRequest.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.wrappedRequest.getLastHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.wrappedRequest.getAllHeaders();
    }

    public void addHeader(Header header) {
        this.wrappedRequest.addHeader(header);
    }

    public void addHeader(String name, String value) {
        this.wrappedRequest.addHeader(name, value);
    }

    public void setHeader(Header header) {
        this.wrappedRequest.setHeader(header);
    }

    public void setHeader(String name, String value) {
        this.wrappedRequest.setHeader(name, value);
    }

    public void setHeaders(Header[] headers) {
        this.wrappedRequest.setHeaders(headers);
    }

    public void removeHeader(Header header) {
        this.wrappedRequest.removeHeader(header);
    }

    public void removeHeaders(String name) {
        this.wrappedRequest.removeHeaders(name);
    }

    public HeaderIterator headerIterator() {
        return this.wrappedRequest.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.wrappedRequest.headerIterator(name);
    }

    public HttpParams getParams() {
        return this.wrappedRequest.getParams();
    }

    public void setParams(HttpParams params) {
        this.wrappedRequest.setParams(params);
    }

    public Driver getDriver() {
        return this.driver;
    }

    public UserContext getUserContext() {
        return this.userContext;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public ContainerRequestContext getContext() {
        return this.wrappedRequest.getContext();
    }

    public IncomingRequest getOriginalRequest() {
        return this.wrappedRequest;
    }

    public boolean isExternal() {
        return this.external;
    }
}

