/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.FragmentEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveResponseHeader
implements IEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(MoveResponseHeader.class);
    private final String srcName;
    private final String targetName;

    public MoveResponseHeader(String srcName, String targetName) {
        this.srcName = srcName;
        this.targetName = targetName;
    }

    @Override
    public boolean event(EventDefinition id, Event event) {
        FragmentEvent fEvent = (FragmentEvent)event;
        MoveResponseHeader.moveHeader((HttpResponse)fEvent.getHttpResponse(), this.srcName, this.targetName);
        return true;
    }

    public static void moveHeader(HttpResponse response, String srcName, String targetName) {
        if (response.containsHeader(srcName)) {
            LOG.info("Moving header {} to {}", (Object)srcName, (Object)targetName);
            Header[] headers = response.getHeaders(srcName);
            response.removeHeaders(targetName);
            for (Header h : headers) {
                response.addHeader(targetName, h.getValue());
            }
            response.removeHeaders(srcName);
        }
    }
}

