/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.util.Collection;
import java.util.Properties;
import org.apache.http.HttpResponse;
import org.esigate.Parameters;
import org.esigate.http.HttpResponseUtils;

public class ContentTypeHelper {
    private Collection<String> parsableContentTypes;

    public ContentTypeHelper(Properties properties) {
        this.parsableContentTypes = Parameters.PARSABLE_CONTENT_TYPES.getValueList(properties);
    }

    public boolean isTextContentType(HttpResponse httpResponse) {
        String contentType = HttpResponseUtils.getFirstHeader("Content-Type", httpResponse);
        return this.isTextContentType(contentType);
    }

    public boolean isTextContentType(String contentType) {
        if (contentType != null) {
            String lowerContentType = contentType.toLowerCase();
            for (String textContentType : this.parsableContentTypes) {
                if (!lowerContentType.startsWith(textContentType)) continue;
                return true;
            }
        }
        return false;
    }
}

