/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension.surrogate;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.esigate.Driver;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.FetchEvent;
import org.esigate.events.impl.ProxyEvent;
import org.esigate.extension.Extension;
import org.esigate.extension.surrogate.CapabilitiesEvent;
import org.esigate.http.DeleteResponseHeader;
import org.esigate.http.MoveResponseHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Surrogate
implements Extension,
IEventListener {
    private static final String H_SURROGATE_CONTROL = "Surrogate-Control";
    private static final String H_SURROGATE_CAPABILITIES = "Surrogate-Capabilities";
    private static final Logger LOG = LoggerFactory.getLogger(Surrogate.class);
    public static final String H_X_ENABLED_CAPABILITIES = "X-Esigate-Internal-Enabled-Capabilities";
    private static final String H_X_SURROGATE = "X-Esigate-Internal-Surrogate";
    private static final String H_X_ORIGINAL_CACHE_CONTROL = "X-Esigate-Int-Surrogate-OCC";
    private static final String H_X_NEXT_SURROGATE_CONTROL = "X-Esigate-Int-Surrogate-NSC";
    private String[] capabilities;
    private String esigateToken;
    public static final EventDefinition EVENT_SURROGATE_CAPABILITIES = new EventDefinition("org.esigate.surrogate.capabilities", 1);
    private static final String CAP_SURROGATE = "Surrogate/1.0";

    @Override
    public void init(Driver driver, Properties properties) {
        CapabilitiesEvent capEvent = new CapabilitiesEvent();
        capEvent.getCapabilities().add(CAP_SURROGATE);
        driver.getEventManager().fire(EVENT_SURROGATE_CAPABILITIES, capEvent);
        this.capabilities = capEvent.getCapabilities().toArray(new String[0]);
        LOG.info("Surrogate capabilities: {}", (Object)StringUtils.join((Object[])this.capabilities, (String)" "));
        this.esigateToken = "=\"" + StringUtils.join((Object[])this.capabilities, (String)" ") + "\"";
        driver.getEventManager().register(EventManager.EVENT_FETCH_PRE, this);
        driver.getEventManager().register(EventManager.EVENT_FETCH_POST, this);
        driver.getEventManager().register(EventManager.EVENT_PROXY_PRE, this);
        driver.getEventManager().register(EventManager.EVENT_PROXY_POST, this);
        driver.getEventManager().register(EventManager.EVENT_FRAGMENT_POST, new MoveResponseHeader(H_X_ORIGINAL_CACHE_CONTROL, "Cache-Control"));
        driver.getEventManager().register(EventManager.EVENT_PROXY_POST, new DeleteResponseHeader(H_X_ENABLED_CAPABILITIES));
    }

    private static String getUniqueToken(String currentCapabilitiesHeader) {
        String token = "esigate";
        if (currentCapabilitiesHeader != null && currentCapabilitiesHeader.contains(token + "=\"")) {
            int id = 2;
            while (currentCapabilitiesHeader.contains(token + id + "=\"")) {
                ++id;
            }
            token = token + id;
        }
        return token;
    }

    @Override
    public boolean event(EventDefinition id, Event event) {
        if (EventManager.EVENT_FETCH_PRE.equals(id)) {
            FetchEvent e = (FetchEvent)event;
            Header h = e.getHttpRequest().getFirstHeader(H_SURROGATE_CAPABILITIES);
            StringBuilder archCapabilities = new StringBuilder(256);
            if (h != null && !StringUtils.isEmpty((CharSequence)h.getValue())) {
                archCapabilities.append(StringUtils.defaultString((String)h.getValue()));
                archCapabilities.append(", ");
            }
            archCapabilities.append(Surrogate.getUniqueToken(h == null ? null : h.getValue()));
            archCapabilities.append(this.esigateToken);
            e.getHttpRequest().setHeader(H_SURROGATE_CAPABILITIES, archCapabilities.toString());
            e.getHttpRequest().removeHeaders(H_X_SURROGATE);
        } else if (EventManager.EVENT_FETCH_POST.equals(id)) {
            this.onPostFetch(event);
        } else if (EventManager.EVENT_PROXY_PRE.equals(id)) {
            ProxyEvent e = (ProxyEvent)event;
            if (e.getOriginalRequest().containsHeader(H_SURROGATE_CAPABILITIES)) {
                e.getOriginalRequest().setHeader(H_X_SURROGATE, "true");
            }
        } else if (EventManager.EVENT_PROXY_POST.equals(id)) {
            ProxyEvent e = (ProxyEvent)event;
            if (e.getResponse() != null) {
                Surrogate.processSurrogateControlContent((HttpResponse)e.getResponse(), e.getOriginalRequest().containsHeader(H_X_SURROGATE));
            } else if (e.getErrorPage() != null) {
                Surrogate.processSurrogateControlContent((HttpResponse)e.getErrorPage().getHttpResponse(), e.getOriginalRequest().containsHeader(H_X_SURROGATE));
            }
        }
        return true;
    }

    private void onPostFetch(Event event) {
        String[] control;
        FetchEvent e = (FetchEvent)event;
        if (!e.getHttpResponse().containsHeader(H_SURROGATE_CONTROL)) {
            return;
        }
        ArrayList<String> enabledCapabilities = new ArrayList<String>();
        ArrayList<String> remainingCapabilities = new ArrayList<String>();
        ArrayList<String> newSurrogateControlL = new ArrayList<String>();
        ArrayList<String> newCacheContent = new ArrayList<String>();
        String controlHeader = e.getHttpResponse().getFirstHeader(H_SURROGATE_CONTROL).getValue();
        for (String directive : control = StringUtils.split((String)controlHeader, (String)",")) {
            if ((directive = StringUtils.strip((String)directive)).startsWith("content=\"")) {
                String[] content;
                for (String contentCap : content = StringUtils.split((String)directive.substring("content=\"".length(), directive.length() - 1), (String)" ")) {
                    if (ArrayUtils.contains((Object[])this.capabilities, (Object)(contentCap = StringUtils.strip((String)contentCap)))) {
                        enabledCapabilities.add(contentCap);
                        continue;
                    }
                    remainingCapabilities.add(contentCap);
                }
                if (remainingCapabilities.size() <= 0) continue;
                newSurrogateControlL.add("content=\"" + StringUtils.join(remainingCapabilities, (String)" ") + "\"");
                continue;
            }
            if (directive.startsWith("max-age=")) {
                String[] maxAge = StringUtils.split((String)directive, (String)"+");
                newCacheContent.add(maxAge[0]);
                if (maxAge.length > 1) {
                    newCacheContent.add("stale-while-revalidate=" + maxAge[1]);
                    newCacheContent.add("stale-if-error=" + maxAge[1]);
                }
                newSurrogateControlL.add(directive);
                continue;
            }
            if (directive.startsWith("no-store")) {
                newSurrogateControlL.add(directive);
                newCacheContent.add(directive);
                continue;
            }
            newSurrogateControlL.add(directive);
        }
        e.getHttpResponse().setHeader(H_X_ENABLED_CAPABILITIES, StringUtils.join(enabledCapabilities, (String)" "));
        e.getHttpResponse().setHeader(H_X_NEXT_SURROGATE_CONTROL, StringUtils.join(newSurrogateControlL, (String)", "));
        if (newCacheContent.size() > 0) {
            MoveResponseHeader.moveHeader((HttpResponse)e.getHttpResponse(), "Cache-Control", H_X_ORIGINAL_CACHE_CONTROL);
            e.getHttpResponse().setHeader("Cache-Control", StringUtils.join(newCacheContent, (String)", "));
        }
    }

    private static void processSurrogateControlContent(HttpResponse response, boolean keepHeader) {
        if (!response.containsHeader(H_SURROGATE_CONTROL)) {
            return;
        }
        if (!keepHeader) {
            response.removeHeaders(H_SURROGATE_CONTROL);
            return;
        }
        MoveResponseHeader.moveHeader(response, H_X_NEXT_SURROGATE_CONTROL, H_SURROGATE_CONTROL);
    }
}

