/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension;

import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.protocol.HttpContext;
import org.esigate.Driver;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.FragmentEvent;
import org.esigate.extension.Extension;
import org.esigate.http.RedirectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentLogging
implements Extension,
IEventListener {
    private static final String TIME = "org.esigate.time";
    private static final Logger LOG = LoggerFactory.getLogger(FragmentLogging.class);
    private Driver driver;

    @Override
    public void init(Driver driver, Properties properties) {
        this.driver = driver;
        driver.getEventManager().register(EventManager.EVENT_FRAGMENT_POST, this);
        driver.getEventManager().register(EventManager.EVENT_FRAGMENT_PRE, this);
    }

    @Override
    public boolean event(EventDefinition id, Event event) {
        FragmentEvent e = (FragmentEvent)event;
        if (EventManager.EVENT_FRAGMENT_PRE.equals(id)) {
            e.getHttpContext().setAttribute(TIME, System.currentTimeMillis());
        } else {
            int statusCode = e.getHttpResponse().getStatusLine().getStatusCode();
            if (LOG.isInfoEnabled() || statusCode >= 400) {
                HttpRequest lastRequest = RedirectStrategy.getLastRequest((HttpRequest)e.getHttpRequest(), (HttpContext)e.getHttpContext());
                HttpHost targetHost = e.getHttpContext().getTargetHost();
                String requestLine = lastRequest.getRequestLine().toString();
                String statusLine = e.getHttpResponse().getStatusLine().toString();
                String reqHeaders = ArrayUtils.toString((Object)lastRequest.getAllHeaders());
                String respHeaders = ArrayUtils.toString((Object)e.getHttpResponse().getAllHeaders());
                String cache = "";
                CacheResponseStatus cacheResponseStatus = (CacheResponseStatus)e.getHttpContext().getAttribute("http.cache.response.status");
                if (cacheResponseStatus != null) {
                    cache = cacheResponseStatus.toString();
                }
                long time = System.currentTimeMillis() - (Long)e.getHttpContext().removeAttribute(TIME);
                StringBuilder logMessage = new StringBuilder(256);
                logMessage.append(this.driver.getConfiguration().getInstanceName());
                logMessage.append(" ");
                if (targetHost != null) {
                    logMessage.append(targetHost.getSchemeName());
                    logMessage.append("://");
                    logMessage.append(targetHost.getHostName());
                    if (targetHost.getPort() != -1) {
                        logMessage.append(":");
                        logMessage.append(targetHost.getPort());
                    }
                    logMessage.append(" - ");
                }
                logMessage.append(requestLine + " " + reqHeaders + " -> " + statusLine + " (" + time + " ms) " + cache + " " + respHeaders);
                if (statusCode >= 400) {
                    LOG.warn(logMessage.toString());
                } else {
                    LOG.info(logMessage.toString());
                }
            }
        }
        return true;
    }
}

