/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension;

import java.util.Collection;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.esigate.Driver;
import org.esigate.Parameters;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.FetchEvent;
import org.esigate.extension.Extension;
import org.esigate.util.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCharset
implements Extension,
IEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCharset.class);
    public static final Parameter PARAM_DEFAULT_CHARSET = new Parameter("defaultCharset", "ISO-8859-1");
    private Collection<String> parsableContentTypes;
    private String defaultCharset;

    @Override
    public void init(Driver driver, Properties properties) {
        driver.getEventManager().register(EventManager.EVENT_FETCH_POST, this);
        this.parsableContentTypes = Parameters.PARSABLE_CONTENT_TYPES.getValueList(properties);
        this.defaultCharset = PARAM_DEFAULT_CHARSET.getValueString(properties);
        LOG.info("Will use " + this.defaultCharset + " as default charset for " + this.parsableContentTypes.toString());
    }

    @Override
    public boolean event(EventDefinition arg0, Event arg1) {
        FetchEvent fe = (FetchEvent)arg1;
        Header contentTypeHeader = fe.getHttpResponse().getFirstHeader("Content-Type");
        if (contentTypeHeader == null) {
            return true;
        }
        String contentType = contentTypeHeader.getValue();
        if (StringUtils.containsIgnoreCase((CharSequence)contentType, (CharSequence)"charset")) {
            return true;
        }
        boolean parsable = false;
        for (String parseableContentType : this.parsableContentTypes) {
            if (!StringUtils.containsIgnoreCase((CharSequence)contentType, (CharSequence)parseableContentType)) continue;
            parsable = true;
            break;
        }
        if (parsable) {
            fe.getHttpResponse().setHeader("Content-Type", contentType + "; charset=" + this.defaultCharset);
        }
        return true;
    }
}

