/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.esi;

import org.esigate.esi.BaseElement;
import org.esigate.esi.BaseElementType;
import org.esigate.esi.InlineCache;
import org.esigate.esi.Tag;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContext;
import org.esigate.util.UriUtils;

class InlineElement
extends BaseElement {
    public static final ElementType TYPE = new BaseElementType("<esi:inline", "</esi:inline"){

        @Override
        public InlineElement newInstance() {
            return new InlineElement();
        }
    };
    private String uri;
    private boolean fetchable;
    private StringBuilder buf = new StringBuilder(1024);

    InlineElement() {
    }

    @Override
    protected void parseTag(Tag tag, ParserContext ctx) {
        this.uri = tag.getAttribute("name");
        this.fetchable = "yes".equalsIgnoreCase(tag.getAttribute("fetchable"));
    }

    @Override
    public void characters(CharSequence csq, int start, int end) {
        this.buf.append(csq, start, end);
    }

    @Override
    public void onTagEnd(String tag, ParserContext ctx) {
        String originalUrl = UriUtils.getPath(ctx.getHttpRequest().getRequestLine().getUri());
        InlineCache.storeFragment(this.uri, null, this.fetchable, originalUrl, this.buf.toString());
    }
}

