/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.memcached.KeyHashingScheme;
import org.apache.http.impl.client.cache.memcached.MemcachedCacheEntryFactory;
import org.apache.http.impl.client.cache.memcached.MemcachedCacheEntryFactoryImpl;
import org.apache.http.impl.client.cache.memcached.MemcachedHttpCacheStorage;
import org.apache.http.impl.client.cache.memcached.SHA256KeyHashingScheme;
import org.esigate.ConfigurationException;
import org.esigate.Parameters;
import org.esigate.cache.CacheConfigHelper;
import org.esigate.cache.CacheStorage;

public class MemcachedCacheStorage
extends CacheStorage {
    @Override
    public void init(Properties properties) {
        MemcachedClient memcachedClient;
        Collection<String> serverStringList = Parameters.MEMCACHED_SERVERS_PROPERTY.getValueList(properties);
        if (serverStringList.isEmpty()) {
            throw new ConfigurationException("No memcached server defined. Property '" + Parameters.MEMCACHED_SERVERS_PROPERTY + "' must be defined.");
        }
        ArrayList<InetSocketAddress> servers = new ArrayList<InetSocketAddress>();
        for (String server : serverStringList) {
            String[] serverHostPort = server.split(":");
            if (serverHostPort.length != 2) {
                throw new ConfigurationException("Invalid memcached server: '" + server + "'. Each server must be in format 'host:port'.");
            }
            String host = serverHostPort[0];
            try {
                int port = Integer.parseInt(serverHostPort[1]);
                servers.add(new InetSocketAddress(host, port));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Invalid memcached server: '" + server + "'. Each server must be in format 'host:port'. Port must be an integer.", e);
            }
        }
        try {
            memcachedClient = new MemcachedClient(servers);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        CacheConfig cacheConfig = CacheConfigHelper.createCacheConfig(properties);
        this.setImpl((HttpCacheStorage)new MemcachedHttpCacheStorage((MemcachedClientIF)memcachedClient, cacheConfig, (MemcachedCacheEntryFactory)new MemcachedCacheEntryFactoryImpl(), (KeyHashingScheme)new SHA256KeyHashingScheme()));
    }
}

