/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.apache.http.HttpException;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.protocol.HttpContext;
import org.esigate.ConfigurationException;
import org.esigate.Parameters;
import org.esigate.http.DateUtils;
import org.esigate.http.OutgoingRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(CacheAdapter.class);
    private int staleIfError;
    private int staleWhileRevalidate;
    private int ttl;
    private boolean xCacheHeader;
    private boolean viaHeader;

    public void init(Properties properties) {
        this.staleIfError = Parameters.STALE_IF_ERROR.getValueInt(properties);
        this.staleWhileRevalidate = Parameters.STALE_WHILE_REVALIDATE.getValueInt(properties);
        int maxAsynchronousWorkers = Parameters.MAX_ASYNCHRONOUS_WORKERS.getValueInt(properties);
        if (this.staleWhileRevalidate > 0 && maxAsynchronousWorkers == 0) {
            throw new ConfigurationException("You must set a positive value for maxAsynchronousWorkers in order to enable background revalidation (staleWhileRevalidate)");
        }
        this.ttl = Parameters.TTL.getValueInt(properties);
        this.xCacheHeader = Parameters.X_CACHE_HEADER.getValueBoolean(properties);
        this.viaHeader = Parameters.VIA_HEADER.getValueBoolean(properties);
        LOG.info("Initializing cache for provider " + Parameters.REMOTE_URL_BASE.getValueString(properties) + " staleIfError=" + this.staleIfError + " staleWhileRevalidate=" + this.staleWhileRevalidate + " ttl=" + this.ttl + " xCacheHeader=" + this.xCacheHeader + " viaHeader=" + this.viaHeader);
    }

    public ClientExecChain wrapCachingHttpClient(final ClientExecChain wrapped) {
        return new ClientExecChain(){

            public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext httpClientContext, HttpExecutionAware execAware) throws IOException, HttpException {
                OutgoingRequestContext context = OutgoingRequestContext.adapt((HttpContext)httpClientContext);
                CloseableHttpResponse response = wrapped.execute(route, request, (HttpClientContext)context, execAware);
                if (request.getRequestLine().getMethod().equalsIgnoreCase("GET") && (CacheAdapter.this.staleWhileRevalidate > 0 || CacheAdapter.this.staleIfError > 0)) {
                    response.removeHeader(response.getLastHeader("Cache-control"));
                }
                if (CacheAdapter.this.xCacheHeader && context != null) {
                    CacheResponseStatus cacheResponseStatus = (CacheResponseStatus)context.getAttribute("http.cache.response.status");
                    String xCacheString = cacheResponseStatus.equals((Object)CacheResponseStatus.CACHE_HIT) ? "HIT" : (cacheResponseStatus.equals((Object)CacheResponseStatus.VALIDATED) ? "VALIDATED" : "MISS");
                    xCacheString = xCacheString + " from " + route.getTargetHost().toHostString();
                    xCacheString = xCacheString + " (" + request.getRequestLine().getMethod() + " " + request.getRequestLine().getUri() + ")";
                    response.addHeader("X-Cache", xCacheString);
                }
                if (!CacheAdapter.this.viaHeader && response.containsHeader("Via")) {
                    response.removeHeaders("Via");
                }
                return response;
            }
        };
    }

    public ClientExecChain wrapBackendHttpClient(final ClientExecChain wrapped) {
        return new ClientExecChain(){

            private boolean isCacheableStatus(int statusCode) {
                return statusCode == 200 || statusCode == 301 || statusCode == 302 || statusCode == 404 || statusCode == 500 || statusCode == 503 || statusCode == 304 || statusCode == 504;
            }

            public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext httpClientContext, HttpExecutionAware execAware) throws IOException, HttpException {
                OutgoingRequestContext context = OutgoingRequestContext.adapt((HttpContext)httpClientContext);
                CloseableHttpResponse response = wrapped.execute(route, request, (HttpClientContext)context, execAware);
                String method = request.getRequestLine().getMethod();
                int statusCode = response.getStatusLine().getStatusCode();
                if (CacheAdapter.this.ttl > 0 && method.equalsIgnoreCase("GET") && this.isCacheableStatus(statusCode)) {
                    response.removeHeaders("Date");
                    response.removeHeaders("Cache-control");
                    response.removeHeaders("Expires");
                    response.setHeader("Date", DateUtils.formatDate(new Date(System.currentTimeMillis())));
                    response.setHeader("Cache-control", "public, max-age=" + CacheAdapter.this.ttl);
                    response.setHeader("Expires", DateUtils.formatDate(new Date(System.currentTimeMillis() + (long)CacheAdapter.this.ttl * 1000L)));
                }
                if (request.getRequestLine().getMethod().equalsIgnoreCase("GET")) {
                    String cacheControlHeader = "";
                    if (CacheAdapter.this.staleWhileRevalidate > 0) {
                        cacheControlHeader = cacheControlHeader + "stale-while-revalidate=" + CacheAdapter.this.staleWhileRevalidate;
                    }
                    if (CacheAdapter.this.staleIfError > 0) {
                        if (cacheControlHeader.length() > 0) {
                            cacheControlHeader = cacheControlHeader + ",";
                        }
                        cacheControlHeader = cacheControlHeader + "stale-if-error=" + CacheAdapter.this.staleIfError;
                    }
                    if (cacheControlHeader.length() > 0) {
                        response.addHeader("Cache-control", cacheControlHeader);
                    }
                }
                return response;
            }
        };
    }
}

