/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.Pair;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.aggregator.AggregateRenderer;
import org.esigate.extension.parallelesi.EsiRenderer;
import org.esigate.impl.UriMapping;
import org.esigate.servlet.HttpServletMediator;
import org.esigate.servlet.impl.DriverSelector;
import org.esigate.servlet.impl.RequestUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelAggregatorServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ParallelAggregatorServlet.class);
    private DriverSelector driverSelector = new DriverSelector();
    private Executor esiExecutor;

    public DriverSelector getDriverSelector() {
        return this.driverSelector;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServletMediator mediator = new HttpServletMediator(request, response, this.getServletContext());
        try {
            Pair<Driver, UriMapping> dm = this.driverSelector.selectProvider(request);
            String relUrl = RequestUrl.getRelativeUrl(request, (UriMapping)dm.getRight());
            LOG.debug("Proxying {}", (Object)relUrl);
            ((Driver)dm.getLeft()).proxy(relUrl, mediator.getHttpRequest(), new AggregateRenderer(), new EsiRenderer(this.esiExecutor));
        }
        catch (HttpErrorPage e) {
            mediator.sendResponse(e.getHttpResponse());
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.driverSelector.setWebXmlProvider(config.getInitParameter("provider"));
        this.driverSelector.setWebXmlProviders(config.getInitParameter("providers"));
        this.driverSelector.setUseMappings("true".equalsIgnoreCase(config.getInitParameter("useMappings")));
        String strMaxThreads = config.getInitParameter("esi_max_threads");
        int maxThreads = 20;
        if (strMaxThreads != null) {
            try {
                maxThreads = Integer.parseInt(strMaxThreads);
            }
            catch (NumberFormatException e) {
                throw new ServletException("Invalid value for esi_max_threads : " + strMaxThreads, (Throwable)e);
            }
        }
        this.esiExecutor = new ThreadPoolExecutor(0, maxThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        LOG.info("Multi-threaded ESI processing enabled. Thread limit: {}.", (Object)String.valueOf(maxThreads));
        DriverFactory.ensureConfigured();
    }
}

