/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.esigate.ConfigurationException;
import org.esigate.Driver;
import org.esigate.extension.Extension;
import org.esigate.util.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionFactory.class);

    public static final <T extends Extension> T getExtension(Properties properties, Parameter parameter, Driver d) {
        Extension result = null;
        String className = parameter.getValueString(properties);
        if (className == null) {
            return null;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating  extension " + className);
            }
            result = (Extension)Class.forName(className).newInstance();
            result.init(d, properties);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(e);
        }
        return (T)result;
    }

    public static final <T extends Extension> List<T> getExtensions(Properties properties, Parameter parameter, Driver d) {
        Collection<String> className = parameter.getValueList(properties);
        if (className == null) {
            return null;
        }
        ArrayList<Extension> finalResult = new ArrayList<Extension>();
        for (String cName : className) {
            try {
                Extension result = null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating  extension " + className);
                }
                result = (Extension)Class.forName(cName).newInstance();
                result.init(d, properties);
                finalResult.add(result);
            }
            catch (InstantiationException e) {
                throw new ConfigurationException(e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException(e);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(e);
            }
        }
        return finalResult;
    }
}

