/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.vars;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequest;
import org.apache.http.cookie.Cookie;
import org.esigate.ConfigurationException;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.util.HttpRequestHelper;
import org.esigate.util.UriUtils;
import org.esigate.vars.VarUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariablesResolver {
    private static final Logger LOG = LoggerFactory.getLogger(VariablesResolver.class);
    private static Pattern userAgentVersion = Pattern.compile("^[A-Za-z]+/([0-9]+\\.[0-9]+)");
    private static Properties properties;
    private static Pattern VAR_PATTERN;

    private VariablesResolver() {
    }

    public static final void configure() {
        InputStream inputStream = null;
        try {
            LOG.debug("Loading esigate-vars.properties file");
            inputStream = Driver.class.getResourceAsStream("/esigate-vars.properties");
            if (inputStream == null) {
                inputStream = Driver.class.getResourceAsStream("vars.properties");
            }
            if (inputStream != null) {
                properties = new Properties();
                properties.load(inputStream);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static boolean containsVariable(String strVars) {
        return strVars.contains("$(") && strVars.contains(")");
    }

    public static String replaceAllVariables(String strVars) {
        return VariablesResolver.replaceAllVariables(strVars, null);
    }

    public static String replaceAllVariables(String strVars, HttpRequest request) {
        String result = strVars;
        if (VariablesResolver.containsVariable(strVars)) {
            Matcher matcher = VAR_PATTERN.matcher(strVars);
            while (matcher.find()) {
                String value;
                String group = matcher.group();
                String var = group.substring(2, group.length() - 1);
                String arg = null;
                int argIndex = var.indexOf(123);
                if (argIndex != -1) {
                    arg = var.substring(argIndex + 1, var.indexOf(125));
                }
                String defaultValue = "";
                int defaultValueIndex = var.indexOf(124);
                if (defaultValueIndex != -1) {
                    defaultValue = VarUtils.removeSimpleQuotes(var.substring(defaultValueIndex + 1));
                }
                if ((value = VariablesResolver.getProperty(var, arg, request)) == null) {
                    value = defaultValue;
                }
                result = result.replace(group, value);
            }
        }
        return result;
    }

    private static String getProperty(String var, String arg, HttpRequest request) {
        String result = VariablesResolver.processVar(var, arg, request);
        if (properties != null) {
            result = properties.getProperty(var, result);
        }
        LOG.debug("Resolve property $({})={}", (Object)var, (Object)result);
        return result;
    }

    private static String processVar(String var, String arg, HttpRequest request) {
        String res = null;
        if (var.indexOf("QUERY_STRING") != -1) {
            res = arg == null ? UriUtils.createUri(request.getRequestLine().getUri()).getRawQuery() : HttpRequestHelper.getParameter(request, arg);
        } else if (var.indexOf("HTTP_ACCEPT_LANGUAGE") != -1) {
            String langs = HttpRequestHelper.getFirstHeader("Accept-Language", request);
            res = arg == null ? langs : String.valueOf(langs != null && langs.indexOf(arg) != -1);
        } else if (var.indexOf("HTTP_HOST") != -1) {
            res = HttpRequestHelper.getFirstHeader("Host", request);
        } else if (var.indexOf("HTTP_REFERER") != -1) {
            res = HttpRequestHelper.getFirstHeader("Referer", request);
        } else if (var.indexOf("HTTP_COOKIE") != -1) {
            if (arg == null) {
                res = HttpRequestHelper.getFirstHeader("Cookie", request);
            } else {
                Cookie[] cookies;
                for (Cookie c : cookies = HttpRequestHelper.getMediator(request).getCookies()) {
                    if (!c.getName().equals(arg)) continue;
                    res = c.getValue();
                    break;
                }
            }
        } else if (var.indexOf("HTTP_USER_AGENT") != -1) {
            if (arg == null) {
                res = HttpRequestHelper.getFirstHeader("User-agent", request);
            } else {
                Matcher m;
                String userAgent = StringUtils.defaultString((String)HttpRequestHelper.getFirstHeader("User-Agent", request)).toLowerCase();
                if (arg.equals("os")) {
                    res = userAgent.indexOf("unix") != -1 ? "UNIX" : (userAgent.indexOf("mac") != -1 ? "MAC" : (userAgent.indexOf("windows") != -1 ? "WIN" : "OTHER"));
                } else if (arg.equals("browser")) {
                    res = userAgent.indexOf("msie") != -1 ? "MSIE" : "MOZILLA";
                } else if (arg.equals("version") && (m = userAgentVersion.matcher(userAgent)).find()) {
                    res = m.group(1);
                }
            }
        } else if (var.indexOf("PROVIDER") != -1) {
            String providerUrl = "";
            try {
                Driver driver = DriverFactory.getInstance(arg);
                providerUrl = driver.getConfiguration().getBaseUrlRetrieveStrategy().getBaseURL(request);
            }
            catch (Exception e) {
                // empty catch block
            }
            return providerUrl;
        }
        return res;
    }

    static {
        VariablesResolver.configure();
        VAR_PATTERN = Pattern.compile("\\$\\((.*?)\\)");
    }
}

