/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.test.http;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.esigate.api.ContainerRequestMediator;
import org.esigate.test.MockMediator;
import org.esigate.util.HttpRequestHelper;
import org.esigate.util.UriUtils;

public class HttpRequestBuilder {
    ProtocolVersion protocolVersion = new ProtocolVersion("HTTP", 1, 1);
    String uriString = "http://localhost/";
    List<Header> headers = new ArrayList<Header>();
    List<Cookie> cookies = new ArrayList<Cookie>();
    HttpEntity entity = null;
    private String method = "GET";
    boolean mockMediator = false;
    ContainerRequestMediator mediator = null;

    public HttpRequestBuilder uri(String uri) {
        this.uriString = uri;
        return this;
    }

    public HttpRequestBuilder header(String name, String value) {
        this.headers.add((Header)new BasicHeader(name, value));
        return this;
    }

    public HttpRequestBuilder method(String paramMethod) {
        this.method = paramMethod;
        return this;
    }

    public HttpRequestBuilder protocolVersion(ProtocolVersion paramProtocolVersion) {
        this.protocolVersion = paramProtocolVersion;
        return this;
    }

    public HttpRequestBuilder cookie(String name, String value) {
        this.cookies.add((Cookie)new BasicClientCookie(name, value));
        return this;
    }

    public HttpRequestBuilder entity(HttpEntity paramEntity) {
        this.entity = paramEntity;
        return this;
    }

    public HttpRequestBuilder mockMediator() {
        if (this.mediator != null) {
            throw new IllegalArgumentException("Cannot use both mockMediator and mediator when building HttpRequest");
        }
        this.mockMediator = true;
        return this;
    }

    public HttpRequestBuilder mediator(ContainerRequestMediator paramMediator) {
        if (this.mockMediator) {
            throw new IllegalArgumentException("Cannot use both mockMediator and mediator when building HttpRequest");
        }
        this.mediator = paramMediator;
        return this;
    }

    public HttpEntityEnclosingRequest build() {
        BasicHttpEntityEnclosingRequest request = null;
        URI uri = UriUtils.createUri(this.uriString);
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        request = new BasicHttpEntityEnclosingRequest(this.method, this.uriString, this.protocolVersion);
        if (port == -1 || port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme)) {
            request.setHeader("Host", host);
        } else {
            request.setHeader("Host", host + ":" + port);
        }
        for (Header h : this.headers) {
            request.addHeader(h.getName(), h.getValue());
        }
        if (this.entity != null) {
            request.setEntity(this.entity);
        }
        ContainerRequestMediator requestMediator = null;
        if (this.mockMediator) {
            requestMediator = new MockMediator(this.uriString);
        }
        if (this.mediator != null) {
            requestMediator = this.mediator;
        }
        String cookieHeaderValue = "";
        for (Cookie c : this.cookies) {
            if (StringUtils.isNotBlank((CharSequence)cookieHeaderValue)) {
                cookieHeaderValue = cookieHeaderValue + "; ";
            }
            cookieHeaderValue = cookieHeaderValue + c.getName() + "=" + c.getValue();
        }
        if (StringUtils.isNotBlank((CharSequence)cookieHeaderValue)) {
            request.addHeader("Cookie", cookieHeaderValue);
        }
        if (requestMediator != null) {
            for (Cookie c : this.cookies) {
                requestMediator.addCookie(c);
            }
            HttpRequestHelper.setMediator((HttpRequest)request, requestMediator);
        }
        return request;
    }
}

