/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.test.driver;

import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;

public class MockHttpClient
extends DefaultHttpClient {
    private HttpResponse response;
    private HttpRequest sentRequest;
    private long sleep = 0L;
    private HttpRequestExecutor httpResponseExecutor;
    private final AtomicInteger openConnections = new AtomicInteger(0);

    private void sleep() {
        if (this.sleep > 0L) {
            try {
                Thread.sleep(this.sleep);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected HttpRequestExecutor createRequestExecutor() {
        if (this.httpResponseExecutor != null) {
            return this.httpResponseExecutor;
        }
        return new HttpRequestExecutor(){

            public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
                if (MockHttpClient.this.response == null) {
                    throw new RuntimeException("Mock response was not set");
                }
                MockHttpClient.this.sleep();
                MockHttpClient.this.sentRequest = request;
                return MockHttpClient.this.response;
            }
        };
    }

    protected ClientConnectionManager createClientConnectionManager() {
        return new ClientConnectionManager(){

            public void shutdown() {
            }

            public ClientConnectionRequest requestConnection(final HttpRoute route, Object state) {
                return new ClientConnectionRequest(){

                    public ManagedClientConnection getConnection(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
                        return new ManagedClientConnection(){
                            private boolean open = false;

                            public void releaseConnection() throws IOException {
                                if (this.open) {
                                    MockHttpClient.this.openConnections.decrementAndGet();
                                    this.open = false;
                                }
                            }

                            public void abortConnection() throws IOException {
                                this.releaseConnection();
                            }

                            public int getRemotePort() {
                                return 80;
                            }

                            public InetAddress getRemoteAddress() {
                                throw new RuntimeException("Method not implemented");
                            }

                            public int getLocalPort() {
                                throw new RuntimeException("Method not implemented");
                            }

                            public InetAddress getLocalAddress() {
                                throw new RuntimeException("Method not implemented");
                            }

                            public void shutdown() throws IOException {
                                this.releaseConnection();
                            }

                            public void setSocketTimeout(int timeout) {
                            }

                            public boolean isStale() {
                                return false;
                            }

                            public boolean isOpen() {
                                return this.open;
                            }

                            public int getSocketTimeout() {
                                return 100;
                            }

                            public HttpConnectionMetrics getMetrics() {
                                throw new RuntimeException("Method not implemented");
                            }

                            public void close() throws IOException {
                                this.releaseConnection();
                            }

                            public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
                            }

                            public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
                            }

                            public HttpResponse receiveResponseHeader() throws HttpException, IOException {
                                throw new RuntimeException("Method not implemented");
                            }

                            public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
                                throw new RuntimeException("Method not implemented");
                            }

                            public boolean isResponseAvailable(int timeout) throws IOException {
                                throw new RuntimeException("Method not implemented");
                            }

                            public void flush() throws IOException {
                            }

                            public void unmarkReusable() {
                            }

                            public void tunnelTarget(boolean secure, HttpParams params) throws IOException {
                                throw new RuntimeException("Method not implemented");
                            }

                            public void tunnelProxy(HttpHost next, boolean secure, HttpParams params) throws IOException {
                                throw new RuntimeException("Method not implemented");
                            }

                            public void setState(Object state) {
                                throw new RuntimeException("Method not implemented");
                            }

                            public void setIdleDuration(long duration, TimeUnit unit) {
                            }

                            public void open(HttpRoute route, HttpContext context, HttpParams params) throws IOException {
                                if (this.open) {
                                    throw new IllegalStateException("Connection is already open");
                                }
                                MockHttpClient.this.openConnections.incrementAndGet();
                                this.open = true;
                            }

                            public void markReusable() {
                            }

                            public void layerProtocol(HttpContext context, HttpParams params) throws IOException {
                                throw new RuntimeException("Method not implemented");
                            }

                            public boolean isSecure() {
                                return false;
                            }

                            public boolean isMarkedReusable() {
                                return false;
                            }

                            public Object getState() {
                                throw new RuntimeException("Method not implemented");
                            }

                            public SSLSession getSSLSession() {
                                return null;
                            }

                            public HttpRoute getRoute() {
                                return route;
                            }
                        };
                    }

                    public void abortRequest() {
                    }
                };
            }

            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                try {
                    conn.releaseConnection();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public SchemeRegistry getSchemeRegistry() {
                return SchemeRegistryFactory.createDefault();
            }

            public void closeIdleConnections(long idletime, TimeUnit tunit) {
            }

            public void closeExpiredConnections() {
            }
        };
    }

    public void setHttpResponseExecutor(HttpRequestExecutor httpResponseExecutor) {
        this.httpResponseExecutor = httpResponseExecutor;
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    public void setSleep(long sleep) {
        this.sleep = sleep;
    }

    public HttpRequest getSentRequest() {
        return this.sentRequest;
    }

    public int getOpenConnections() {
        return this.openConnections.get();
    }
}

