/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.tags;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.HttpEntityEnclosingRequest;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.parser.Parser;
import org.esigate.tags.ParamElement;
import org.esigate.tags.TemplateElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateRenderer
implements Renderer,
Appendable {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateRenderer.class);
    private static final Pattern PATTERN = Pattern.compile("<!--\\$[^>]*\\$-->");
    private final Parser parser = new Parser(PATTERN, TemplateElement.TYPE, ParamElement.TYPE);
    private final String page;
    private final String name;
    private final Map<String, String> params;
    private boolean write;
    private Writer out;

    public TemplateRenderer(String name, Map<String, String> params, String page) {
        this.name = name;
        this.params = params;
        this.page = page;
        this.write = name == null;
    }

    @Override
    public void render(HttpEntityEnclosingRequest httpRequest, String content, Writer out) throws IOException, HttpErrorPage {
        LOG.debug("Rendering block " + this.name + " in page " + this.page);
        this.out = out;
        if (content == null) {
            if (this.params != null) {
                for (String value : this.params.values()) {
                    out.write(value);
                }
            }
        } else {
            this.parser.parse(content, this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setWrite(boolean write) {
        this.write = write;
    }

    public String getParam(String name) {
        return this.params.get(name);
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        if (this.write) {
            this.out.append(csq);
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        if (this.write) {
            this.out.append(c);
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        if (this.write) {
            this.out.append(csq, start, end);
        }
        return this;
    }
}

