/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.impl.UriMapping;
import org.esigate.servlet.impl.RequestUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverSelector {
    private String webXmlProvider = null;
    private Map<String, String> webXmlProviderMappings = null;
    private boolean useMappings = false;

    public void setUseMappings(boolean useConfiguration) {
        this.useMappings = useConfiguration;
    }

    public boolean isUseMappings() {
        return this.useMappings;
    }

    public Map<String, String> getWebXmlProviderMappings() {
        return this.webXmlProviderMappings;
    }

    public String getWebXmlProvider() {
        return this.webXmlProvider;
    }

    public void setWebXmlProvider(String provider) {
        this.webXmlProvider = provider;
    }

    public void setWebXmlProviders(String providers) {
        if (providers != null) {
            String[] providersArray;
            this.webXmlProviderMappings = new HashMap<String, String>();
            for (String p : providersArray = StringUtils.split((String)providers, (String)",")) {
                String[] mapping = StringUtils.split((String)p, (String)"=");
                this.webXmlProviderMappings.put(StringUtils.trim((String)mapping[0].toLowerCase(Locale.ENGLISH)), StringUtils.trim((String)mapping[1]));
            }
        }
    }

    public Pair<Driver, UriMapping> selectProvider(HttpServletRequest request) throws HttpErrorPage {
        String mapping;
        String host = request.getHeader("Host");
        String scheme = request.getScheme();
        String relUrl = RequestUrl.getRelativeUrl(request, null);
        if (this.useMappings) {
            return DriverFactory.getInstanceFor(scheme, host, relUrl);
        }
        String targetProvider = this.webXmlProvider;
        if (this.webXmlProviderMappings != null && host != null && (mapping = this.webXmlProviderMappings.get(host = host.toLowerCase(Locale.ENGLISH))) != null) {
            targetProvider = mapping;
        }
        return new ImmutablePair((Object)DriverFactory.getInstance(targetProvider), null);
    }
}

