/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.parser.future;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.esigate.HttpErrorPage;
import org.esigate.parser.future.FutureAppendable;
import org.esigate.parser.future.FutureAppendableAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringBuilderFutureAppendable
implements FutureAppendable,
Future<CharSequence> {
    private static final int DEFAULT_CAPACITY = 1024;
    private final StringBuilder builder;
    private final FutureAppendableAdapter futureBuilder;

    public StringBuilderFutureAppendable() {
        this(1024);
    }

    public StringBuilderFutureAppendable(int capacity) {
        this.builder = new StringBuilder(capacity);
        this.futureBuilder = new FutureAppendableAdapter(this.builder);
    }

    @Override
    public FutureAppendable enqueueAppend(Future<CharSequence> csq) throws IOException {
        return this.futureBuilder.enqueueAppend(csq);
    }

    @Override
    public FutureAppendable performAppends() throws IOException, HttpErrorPage {
        return this.futureBuilder.performAppends();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.futureBuilder.hasPending();
    }

    @Override
    public CharSequence get() throws InterruptedException, ExecutionException {
        try {
            this.futureBuilder.performAppends();
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
        catch (HttpErrorPage e) {
            throw new ExecutionException(e);
        }
        return this.builder.toString();
    }

    @Override
    public CharSequence get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this.futureBuilder.performAppends();
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
        catch (HttpErrorPage e) {
            throw new ExecutionException(e);
        }
        return this.builder.toString();
    }

    @Override
    public boolean hasPending() {
        return this.futureBuilder.hasPending();
    }

    @Override
    public FutureAppendable performAppends(int timeout, TimeUnit unit) throws IOException, HttpErrorPage, TimeoutException {
        return this.futureBuilder.performAppends(timeout, unit);
    }
}

