/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.esigate.ConfigurationException;
import org.esigate.HttpErrorPage;
import org.esigate.Parameters;
import org.esigate.cache.CacheConfigHelper;
import org.esigate.cookie.CookieManager;
import org.esigate.events.EventManager;
import org.esigate.events.impl.FragmentEvent;
import org.esigate.http.GenericHttpRequest;
import org.esigate.http.HeaderManager;
import org.esigate.http.IOExceptionHandler;
import org.esigate.http.RedirectStrategy;
import org.esigate.http.RequestCookieStore;
import org.esigate.http.UnsupportedHttpMethodException;
import org.esigate.util.HttpRequestHelper;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientHelper.class);
    private static final Set<String> SIMPLE_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS", "TRACE", "DELETE")));
    private static final Set<String> ENTITY_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("POST", "PUT", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK")));
    private static final String ORIGINAL_REQUEST_KEY = "ORIGINAL_REQUEST";
    public static final String TARGET_HOST = "TARGET_HOST";
    private final boolean preserveHost;
    private CookieManager cookieManager;
    private HttpClient httpClient;
    private EventManager eventManager = null;
    private HeaderManager headerManager;

    private static final HttpClient buildDefaultHttpClient(Properties properties) {
        HttpHost proxyHost = null;
        UsernamePasswordCredentials proxyCredentials = null;
        String proxyHostParameter = Parameters.PROXY_HOST.getValueString(properties);
        if (proxyHostParameter != null) {
            int proxyPort = Parameters.PROXY_PORT.getValueInt(properties);
            proxyHost = new HttpHost(proxyHostParameter, proxyPort);
            String proxyUser = Parameters.PROXY_USER.getValueString(properties);
            if (proxyUser != null) {
                String proxyPassword = Parameters.PROXY_PASSWORD.getValueString(properties);
                proxyCredentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            }
        }
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            SSLSocketFactory sslSocketFactory = new SSLSocketFactory(sslContext, SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
            Scheme https = new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory);
            schemeRegistry.register(https);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConfigurationException(e);
        }
        catch (KeyManagementException e) {
            throw new ConfigurationException(e);
        }
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(schemeRegistry);
        connectionManager.setMaxTotal(Parameters.MAX_CONNECTIONS_PER_HOST.getValueInt(properties));
        connectionManager.setDefaultMaxPerRoute(Parameters.MAX_CONNECTIONS_PER_HOST.getValueInt(properties));
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)Parameters.CONNECT_TIMEOUT.getValueInt(properties));
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)Parameters.SOCKET_TIMEOUT.getValueInt(properties));
        httpParams.setBooleanParameter("http.protocol.allow-circular-redirects", true);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpParams);
        defaultHttpClient.setRedirectStrategy((org.apache.http.client.RedirectStrategy)new RedirectStrategy());
        if (proxyHost != null) {
            if (proxyCredentials != null) {
                defaultHttpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost.getHostName(), proxyHost.getPort()), (Credentials)proxyCredentials);
            }
            defaultHttpClient.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
        }
        return defaultHttpClient;
    }

    private static final HttpClient decorateWithCache(EventManager d, HttpClient HttpClient2, Properties properties) {
        boolean useCache = Parameters.USE_CACHE.getValueBoolean(properties);
        return CacheConfigHelper.addCache(d, properties, HttpClient2, useCache);
    }

    private HttpClientHelper(Properties properties, CookieManager cookieManager) {
        this.preserveHost = Parameters.PRESERVE_HOST.getValueBoolean(properties);
        this.headerManager = new HeaderManager(properties);
        this.cookieManager = cookieManager;
    }

    public HttpClientHelper(EventManager eventManager, CookieManager cookieManager, HttpClient defaultHttpClient, Properties properties) {
        this(properties, cookieManager);
        this.eventManager = eventManager;
        this.httpClient = HttpClientHelper.decorateWithCache(eventManager, defaultHttpClient, properties);
        this.getClass();
    }

    public HttpClientHelper(EventManager eventManager, CookieManager cookieManager, Properties properties) {
        this(properties, cookieManager);
        this.eventManager = eventManager;
        this.httpClient = HttpClientHelper.decorateWithCache(eventManager, HttpClientHelper.buildDefaultHttpClient(properties), properties);
    }

    public GenericHttpRequest createHttpRequest(HttpEntityEnclosingRequest originalRequest, String uri, boolean proxy) throws HttpErrorPage {
        GenericHttpRequest httpRequest;
        String method;
        HttpHost targetHost = UriUtils.extractHost(uri);
        HttpHost virtualHost = this.preserveHost ? HttpRequestHelper.getHost((HttpRequest)originalRequest) : targetHost;
        uri = UriUtils.rewriteURI(uri, virtualHost).toString();
        String string = method = proxy ? originalRequest.getRequestLine().getMethod().toUpperCase() : "GET";
        if (SIMPLE_METHODS.contains(method)) {
            httpRequest = new GenericHttpRequest(method, uri);
        } else if (ENTITY_METHODS.contains(method)) {
            httpRequest = new GenericHttpRequest(method, uri);
            httpRequest.setEntity(originalRequest.getEntity());
        } else {
            throw new UnsupportedHttpMethodException(method + " " + uri);
        }
        httpRequest.setParams((HttpParams)new DefaultedHttpParams((HttpParams)new BasicHttpParams(), originalRequest.getParams()));
        httpRequest.getParams().setParameter("http.protocol.handle-redirects", (Object)(!proxy ? 1 : 0));
        httpRequest.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        this.headerManager.copyHeaders((HttpRequest)originalRequest, (HttpRequest)httpRequest);
        httpRequest.getParams().setParameter(TARGET_HOST, (Object)targetHost);
        httpRequest.getParams().setParameter(ORIGINAL_REQUEST_KEY, (Object)originalRequest);
        httpRequest.getParams().setParameter("http.request", (Object)httpRequest);
        return httpRequest;
    }

    public HttpResponse execute(GenericHttpRequest httpRequest) {
        HttpEntityEnclosingRequest originalRequest = (HttpEntityEnclosingRequest)httpRequest.getParams().getParameter(ORIGINAL_REQUEST_KEY);
        BasicHttpContext httpContext = new BasicHttpContext();
        if (this.cookieManager != null) {
            RequestCookieStore cookieStore = new RequestCookieStore(this.cookieManager, (HttpRequest)originalRequest);
            httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
        }
        FragmentEvent event = new FragmentEvent();
        event.httpRequest = httpRequest;
        event.originalRequest = originalRequest;
        event.httpResponse = null;
        event.httpContext = httpContext;
        this.eventManager.fire(EventManager.EVENT_FRAGMENT_PRE, event);
        if (!event.exit) {
            if (event.httpResponse == null) {
                BasicHttpResponse result;
                try {
                    HttpHost host = (HttpHost)httpRequest.getParams().getParameter(TARGET_HOST);
                    HttpResponse response = this.httpClient.execute(host, (HttpRequest)httpRequest, (HttpContext)httpContext);
                    result = new BasicHttpResponse(response.getStatusLine());
                    this.headerManager.copyHeaders((HttpRequest)httpRequest, originalRequest, response, (HttpResponse)result);
                    result.setEntity(response.getEntity());
                }
                catch (IOException e) {
                    int statusCode = 500;
                    String statusText = "Error retrieving URL";
                    LOG.warn(httpRequest.getRequestLine() + " -> " + statusCode + " " + statusText);
                    result = IOExceptionHandler.toHttpResponse(e);
                }
                result.setParams(httpRequest.getParams());
                event.httpResponse = result;
            }
            this.eventManager.fire(EventManager.EVENT_FRAGMENT_POST, event);
        }
        return event.httpResponse;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }
}

