/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension.parallelesi;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Pattern;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.extension.parallelesi.BaseElement;
import org.esigate.extension.parallelesi.BaseElementType;
import org.esigate.extension.parallelesi.EsiRenderer;
import org.esigate.extension.parallelesi.InlineCache;
import org.esigate.extension.parallelesi.Tag;
import org.esigate.parser.future.CharSequenceFuture;
import org.esigate.parser.future.FutureElement;
import org.esigate.parser.future.FutureElementType;
import org.esigate.parser.future.FutureParserContext;
import org.esigate.parser.future.StringBuilderFutureAppendable;
import org.esigate.regexp.ReplaceRenderer;
import org.esigate.util.HttpRequestHelper;
import org.esigate.util.UriUtils;
import org.esigate.vars.VariablesResolver;
import org.esigate.xml.XpathRenderer;
import org.esigate.xml.XsltRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IncludeElement
extends BaseElement {
    private static final String PROVIDER_PATTERN = "$(PROVIDER{";
    private static final String LEGACY_PROVIDER_PATTERN = "$PROVIDER({";
    protected static final Logger LOG = LoggerFactory.getLogger(IncludeElement.class);
    public static final FutureElementType TYPE = new BaseElementType("<esi:include", "</esi:include"){

        public IncludeElement newInstance() {
            return new IncludeElement();
        }
    };
    private StringBuilderFutureAppendable buf;
    private Map<String, CharSequence> fragmentReplacements;
    private Map<String, CharSequence> regexpReplacements;
    private Tag includeTag;
    private boolean write = false;

    IncludeElement() {
    }

    @Override
    public void characters(Future<CharSequence> csq) throws IOException {
        if (this.write) {
            this.buf.enqueueAppend(csq);
        }
    }

    @Override
    public void onTagEnd(String tag, FutureParserContext ctx) throws IOException, HttpErrorPage {
        this.write = true;
        String src = this.includeTag.getAttribute("src");
        String alt = this.includeTag.getAttribute("alt");
        boolean ignoreError = "continue".equals(this.includeTag.getAttribute("onerror"));
        FutureElement current = ctx.getCurrent();
        Executor executor = (Executor)ctx.getData("executor");
        Future<CharSequence> result = null;
        IncludeTask task = new IncludeTask(this.includeTag, src, alt, ctx, current, ignoreError, this.fragmentReplacements, this.regexpReplacements, executor);
        if (executor == null) {
            CharSequence content = task.call();
            result = new CharSequenceFuture(content);
        } else {
            FutureTask<CharSequence> r = new FutureTask<CharSequence>(task);
            executor.execute(r);
            result = r;
        }
        ctx.getCurrent().characters(result);
    }

    @Override
    protected void parseTag(Tag tag, FutureParserContext ctx) throws IOException, HttpErrorPage {
        this.buf = new StringBuilderFutureAppendable();
        this.fragmentReplacements = new HashMap<String, CharSequence>();
        this.regexpReplacements = new HashMap<String, CharSequence>();
        this.includeTag = tag;
    }

    void addFragmentReplacement(String fragment, CharSequence replacement) {
        this.fragmentReplacements.put(fragment, replacement);
    }

    void addRegexpReplacement(String regexp, CharSequence replacement) {
        this.regexpReplacements.put(regexp, replacement);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IncludeTask
    implements Callable<CharSequence> {
        String src;
        String alt;
        FutureParserContext ctx;
        private boolean ignoreError;
        FutureElement current;
        Tag includeTag;
        private Map<String, CharSequence> fragmentReplacements;
        private Map<String, CharSequence> regexpReplacements;
        private Executor executor;

        public IncludeTask(Tag includeTag, String src, String alt, FutureParserContext ctx, FutureElement current, boolean ignoreError, Map<String, CharSequence> fragmentReplacements, Map<String, CharSequence> regexpReplacements, Executor executor) {
            this.src = src;
            this.alt = alt;
            this.ctx = ctx;
            this.ignoreError = ignoreError;
            this.current = current;
            this.includeTag = includeTag;
            this.fragmentReplacements = fragmentReplacements;
            this.regexpReplacements = regexpReplacements;
            this.executor = executor;
        }

        @Override
        public CharSequence call() throws IOException, HttpErrorPage {
            LOG.debug("Starting include task {}", (Object)this.src);
            StringWriter sw = new StringWriter();
            Exception currentException = null;
            try {
                this.processPage(this.src, this.includeTag, this.ctx, sw);
            }
            catch (IOException e) {
                currentException = e;
            }
            catch (HttpErrorPage e) {
                currentException = e;
            }
            if (currentException != null && this.alt != null) {
                currentException = null;
                try {
                    this.processPage(this.alt, this.includeTag, this.ctx, sw);
                }
                catch (IOException e) {
                    currentException = e;
                }
                catch (HttpErrorPage e) {
                    currentException = e;
                }
            }
            if (currentException != null && !this.ignoreError && !this.ctx.reportError(this.current, currentException)) {
                if (currentException instanceof IOException) {
                    throw currentException;
                }
                if (currentException instanceof HttpErrorPage) {
                    throw (HttpErrorPage)currentException;
                }
                throw new IllegalStateException("This type of exception is unexpected here. Should be IOException or HttpErrorPageException.", currentException);
            }
            String result = sw.toString();
            if (!this.regexpReplacements.isEmpty()) {
                for (Map.Entry<String, CharSequence> entry : this.regexpReplacements.entrySet()) {
                    result = Pattern.compile(entry.getKey()).matcher(result).replaceAll(entry.getValue().toString());
                }
            }
            return result;
        }

        void processPage(String src, Tag tag, FutureParserContext ctx, Appendable out) throws IOException, HttpErrorPage {
            String provider;
            int endIndex;
            int startIdx;
            Driver driver;
            String page;
            String fragment = tag.getAttribute("fragment");
            String xpath = tag.getAttribute("xpath");
            String xslt = tag.getAttribute("stylesheet");
            boolean rewriteAbsoluteUrl = "true".equalsIgnoreCase(tag.getAttribute("rewriteabsoluteurl"));
            HttpEntityEnclosingRequest httpRequest = ctx.getHttpRequest();
            ArrayList<Renderer> rendererList = new ArrayList<Renderer>();
            int idx = src.indexOf(IncludeElement.PROVIDER_PATTERN);
            int idxLegacyPattern = src.indexOf(IncludeElement.LEGACY_PROVIDER_PATTERN);
            if (idx < 0 && idxLegacyPattern < 0) {
                page = src;
                driver = HttpRequestHelper.getDriver((HttpRequest)httpRequest);
            } else if (idx >= 0) {
                startIdx = idx + IncludeElement.PROVIDER_PATTERN.length();
                endIndex = src.indexOf("})", startIdx);
                provider = src.substring(startIdx, endIndex);
                page = src.substring(endIndex + "})".length());
                driver = DriverFactory.getInstance(provider);
            } else {
                startIdx = idxLegacyPattern + IncludeElement.PROVIDER_PATTERN.length();
                endIndex = src.indexOf("})", startIdx);
                provider = src.substring(startIdx, endIndex);
                page = src.substring(endIndex + "})".length());
                driver = DriverFactory.getInstance(provider);
            }
            if (rewriteAbsoluteUrl) {
                HashMap<String, String> replaceRules = new HashMap<String, String>();
                String baseUrl = HttpRequestHelper.getBaseUrl((HttpRequest)httpRequest).toString();
                String visibleBaseUrl = driver.getConfiguration().getVisibleBaseURL(baseUrl);
                String contextBaseUrl = UriUtils.createUri(baseUrl).getPath();
                if (visibleBaseUrl != null && !visibleBaseUrl.equals("") && !baseUrl.equals(visibleBaseUrl)) {
                    String contextVisibleBaseUrl = UriUtils.createUri(visibleBaseUrl).getPath();
                    replaceRules.put("href=(\"|')" + visibleBaseUrl + "(.*)(\"|')", "href=$1" + contextVisibleBaseUrl + "$2$3");
                    replaceRules.put("src=(\"|')" + visibleBaseUrl + "(.*)(\"|')", "src=$1" + contextVisibleBaseUrl + "$2$3");
                    replaceRules.put("href=(\"|')" + baseUrl + "(.*)(\"|')", "href=$1" + contextBaseUrl + "$2$3");
                    replaceRules.put("src=(\"|')" + baseUrl + "(.*)(\"|')", "src=$1" + contextBaseUrl + "$2$3");
                } else {
                    contextBaseUrl = UriUtils.createUri(baseUrl).getPath();
                    replaceRules.put("href=(\"|')" + baseUrl + "(.*)(\"|')", "href=$1" + contextBaseUrl + "$2$3");
                    replaceRules.put("src=(\"|')" + baseUrl + "(.*)(\"|')", "src=$1" + contextBaseUrl + "$2$3");
                }
                rendererList.add(new ReplaceRenderer(replaceRules));
            }
            page = VariablesResolver.replaceAllVariables(page, (HttpRequest)httpRequest);
            InlineCache ic = InlineCache.getFragment(src);
            if (ic != null && !ic.isExpired()) {
                String cache = ic.getFragment();
                out.append(cache);
            } else {
                EsiRenderer esiRenderer = fragment != null ? new EsiRenderer(page, fragment, this.executor) : new EsiRenderer(this.executor);
                if (this.fragmentReplacements != null && !this.fragmentReplacements.isEmpty()) {
                    esiRenderer.setFragmentsToReplace(this.fragmentReplacements);
                }
                rendererList.add(esiRenderer);
                if (xpath != null) {
                    rendererList.add(new XpathRenderer(xpath));
                } else if (xslt != null) {
                    rendererList.add(new XsltRenderer(xslt, driver, httpRequest));
                }
                driver.render(page, null, out, httpRequest, rendererList.toArray(new Renderer[rendererList.size()]));
            }
        }
    }
}

