/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.util.EntityUtils;
import org.esigate.DriverConfiguration;
import org.esigate.HttpErrorPage;
import org.esigate.Parameters;
import org.esigate.Renderer;
import org.esigate.UserContext;
import org.esigate.cookie.CookieManager;
import org.esigate.events.EventManager;
import org.esigate.events.impl.ProxyEvent;
import org.esigate.events.impl.RenderEvent;
import org.esigate.extension.ExtensionFactory;
import org.esigate.http.GenericHttpRequest;
import org.esigate.http.HttpClientHelper;
import org.esigate.http.HttpResponseUtils;
import org.esigate.http.ResourceUtils;
import org.esigate.util.HttpRequestHelper;
import org.esigate.vars.VariablesResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Driver {
    private static final Logger LOG = LoggerFactory.getLogger(Driver.class);
    private final DriverConfiguration config;
    private HttpClientHelper httpClientHelper;
    private final List<String> parsableContentTypes;
    private final EventManager eventManager;

    private Driver(Properties properties, String name, EventManager eventManagerParam) {
        this.eventManager = eventManagerParam;
        this.config = new DriverConfiguration(name, properties);
        ExtensionFactory.getExtensions(properties, Parameters.EXTENSIONS, this);
        this.parsableContentTypes = new ArrayList<String>();
        String strContentTypes = Parameters.PARSABLE_CONTENT_TYPES.getValueString(properties);
        StringTokenizer tokenizer = new StringTokenizer(strContentTypes, ",");
        while (tokenizer.hasMoreElements()) {
            String contentType = tokenizer.nextToken();
            contentType = contentType.trim();
            this.parsableContentTypes.add(contentType);
        }
    }

    public Driver(String name, Properties properties) {
        this(properties, name, new EventManager());
        CookieManager cookieManager = (CookieManager)ExtensionFactory.getExtension(properties, Parameters.COOKIE_MANAGER, this);
        this.httpClientHelper = new HttpClientHelper(this.eventManager, cookieManager, properties);
    }

    public Driver(String name, Properties properties, HttpClientHelper httpClientHelper) {
        this(properties, name, httpClientHelper.getEventManager());
        this.httpClientHelper = httpClientHelper;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public final void render(String pageUrl, Map<String, String> parameters, Appendable writer, HttpEntityEnclosingRequest originalRequest, Renderer ... renderers) throws IOException, HttpErrorPage {
        this.initHttpRequestParams((HttpRequest)originalRequest, parameters);
        String resultingPageUrl = VariablesResolver.replaceAllVariables(pageUrl, (HttpRequest)originalRequest);
        String currentValue = this.getResourceAsString(resultingPageUrl, originalRequest);
        currentValue = this.performRendering(pageUrl, originalRequest, currentValue, renderers);
        writer.append(currentValue);
    }

    private void logAction(String action, String onUrl, Renderer[] renderers) {
        ArrayList<String> rendererNames = new ArrayList<String>(renderers.length);
        for (Renderer renderer : renderers) {
            rendererNames.add(renderer.getClass().getName());
        }
        LOG.info("render provider={} page= {} renderers={}", new Object[]{this.config.getInstanceName(), onUrl, rendererNames});
    }

    public void initHttpRequestParams(HttpRequest request, Map<String, String> parameters) throws HttpErrorPage {
        HttpRequestHelper.setDriver(request, this);
        HttpRequestHelper.setParameters(request, parameters);
        UserContext userContext = new UserContext(request, this.config.getInstanceName());
        HttpRequestHelper.setUserContext(request, userContext);
        try {
            URL baseUrl = new URL(this.config.getBaseUrlRetrieveStrategy().getBaseURL(request));
            HttpRequestHelper.setBaseUrl(request, baseUrl);
        }
        catch (MalformedURLException e) {
            throw new HttpErrorPage(500, "Internal server error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proxy(String relUrl, HttpEntityEnclosingRequest request, Renderer ... renderers) throws IOException, HttpErrorPage {
        this.initHttpRequestParams((HttpRequest)request, null);
        if (LOG.isInfoEnabled()) {
            this.logAction("render", relUrl, renderers);
        }
        HttpRequestHelper.setCharacterEncoding((HttpRequest)request, this.config.getUriEncoding());
        ProxyEvent e = new ProxyEvent();
        e.originalRequest = request;
        this.eventManager.fire(EventManager.EVENT_PROXY_PRE, e);
        if (e.exit) {
            return;
        }
        String url = ResourceUtils.getHttpUrlWithQueryString(relUrl, e.originalRequest, true);
        GenericHttpRequest httpRequest = this.httpClientHelper.createHttpRequest(request, url, true);
        try {
            HttpResponse httpResponse = this.execute(httpRequest);
            httpResponse = this.performRendering(relUrl, request, httpResponse, renderers);
            try {
                HttpRequestHelper.getMediator((HttpRequest)request).sendResponse(httpResponse);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            }
        }
        catch (HttpErrorPage errorPage) {
            HttpResponse errorResponse = errorPage.getHttpResponse();
            errorResponse = this.performRendering(relUrl, request, errorResponse, renderers);
            throw new HttpErrorPage(errorResponse);
        }
        this.eventManager.fire(EventManager.EVENT_PROXY_POST, e);
    }

    private HttpResponse performRendering(String pageUrl, HttpEntityEnclosingRequest originalRequest, HttpResponse response, Renderer[] renderers) throws HttpErrorPage, IOException {
        if (!this.isTextContentType(response)) {
            LOG.debug("'{}' is binary on no transformation to apply: was forwarded without modification.", (Object)pageUrl);
            return response;
        }
        LOG.debug("'{}' is text : will apply renderers.", (Object)pageUrl);
        String currentValue = HttpResponseUtils.toString(response);
        currentValue = this.performRendering(pageUrl, originalRequest, currentValue, renderers);
        StringEntity transformedHttpEntity = new StringEntity(currentValue, ContentType.get((HttpEntity)response.getEntity()));
        BasicHttpResponse transformedResponse = new BasicHttpResponse(response.getStatusLine());
        transformedResponse.setHeaders(response.getAllHeaders());
        transformedResponse.setEntity((HttpEntity)transformedHttpEntity);
        return transformedResponse;
    }

    private String performRendering(String pageUrl, HttpEntityEnclosingRequest originalRequest, String body, Renderer[] renderers) throws IOException, HttpErrorPage {
        String currentBody = body;
        if (LOG.isInfoEnabled()) {
            this.logAction("render", pageUrl, renderers);
        }
        RenderEvent renderEvent = new RenderEvent();
        renderEvent.originalRequest = originalRequest;
        renderEvent.remoteUrl = pageUrl;
        renderEvent.renderers = new ArrayList<Renderer>(renderers.length + 10);
        renderEvent.renderers.addAll(Arrays.asList(renderers));
        this.eventManager.fire(EventManager.EVENT_RENDER_PRE, renderEvent);
        for (Renderer renderer : renderEvent.renderers) {
            StringWriter stringWriter = new StringWriter();
            renderer.render(originalRequest, currentBody, stringWriter);
            currentBody = stringWriter.toString();
        }
        this.eventManager.fire(EventManager.EVENT_RENDER_POST, renderEvent);
        return currentBody;
    }

    protected String getResourceAsString(String url, HttpEntityEnclosingRequest originalRequest) throws HttpErrorPage {
        String pageBody;
        String targetUrl = ResourceUtils.getHttpUrlWithQueryString(url, (HttpRequest)originalRequest, false);
        boolean cacheable = "GET".equalsIgnoreCase(originalRequest.getRequestLine().getMethod());
        if (cacheable && (pageBody = (String)originalRequest.getParams().getParameter(targetUrl)) != null) {
            return pageBody;
        }
        GenericHttpRequest httpRequest = this.httpClientHelper.createHttpRequest(originalRequest, targetUrl, false);
        HttpResponse httpResponse = this.execute(httpRequest);
        pageBody = HttpResponseUtils.toString(httpResponse);
        if (cacheable) {
            originalRequest.getParams().setParameter(targetUrl, (Object)pageBody);
        }
        return pageBody;
    }

    public DriverConfiguration getConfiguration() {
        return this.config;
    }

    public HttpClientHelper getHttpClientHelper() {
        return this.httpClientHelper;
    }

    private boolean isTextContentType(HttpResponse httpResponse) {
        String contentType = HttpResponseUtils.getFirstHeader("Content-Type", httpResponse);
        return this.isTextContentType(contentType);
    }

    protected boolean isTextContentType(String contentType) {
        if (contentType != null) {
            String lowerContentType = contentType.toLowerCase();
            for (String textContentType : this.parsableContentTypes) {
                if (!lowerContentType.startsWith(textContentType)) continue;
                return true;
            }
        }
        return false;
    }

    public HttpResponse executeSingleRequest(GenericHttpRequest httpRequest) {
        return this.httpClientHelper.execute(httpRequest);
    }

    private HttpResponse execute(GenericHttpRequest httpRequest) throws HttpErrorPage {
        HttpResponse httpResponse = this.executeSingleRequest(httpRequest);
        if (httpResponse == null) {
            throw new HttpErrorPage(500, "Request was cancelled by server", "Request was cancelled by server");
        }
        if (HttpResponseUtils.isError(httpResponse)) {
            throw new HttpErrorPage(httpResponse);
        }
        return httpResponse;
    }
}

