/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.esigate.ConfigurationException;
import org.esigate.util.FilterList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesUtil {
    public static Collection<String> getPropertyValueAsList(Properties properties, String propertyName) {
        return PropertiesUtil.getPropertyValueAsList(properties, propertyName, null);
    }

    public static Collection<String> getPropertyValueAsList(Properties properties, String propertyName, String defaultValue) {
        Collection<String> result;
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null) {
            propertyValue = defaultValue;
        }
        if ((result = PropertiesUtil.toCollection(propertyValue)).contains("*") && result.size() > 1) {
            throw new ConfigurationException(propertyName + " must be a comma-separated list or *");
        }
        return result;
    }

    private static Collection<String> toCollection(String list) {
        HashSet<String> result = new HashSet<String>();
        if (list != null) {
            String[] values;
            for (String value : values = list.split(",")) {
                result.add(value.trim());
            }
        }
        return result;
    }

    public static void populate(FilterList list, Properties properties, String toAddPropertyName, String toRemovePropertyName) {
        Collection<String> toAdd = PropertiesUtil.getPropertyValueAsList(properties, toAddPropertyName);
        Collection<String> toRemove = PropertiesUtil.getPropertyValueAsList(properties, toRemovePropertyName);
        if (toAdd.contains("*") && toRemove.contains("*")) {
            throw new ConfigurationException("cannot use * for " + toAddPropertyName + " and " + toRemovePropertyName + " at the same time");
        }
        if (toRemove.contains("*")) {
            list.remove(toRemove);
            list.add(toAdd);
        } else {
            list.add(toAdd);
            list.remove(toRemove);
        }
    }

    public static void populate(FilterList list, Properties properties, String toAddPropertyName, String toRemovePropertyName, String defaultToAddString, String defaultToRemoveString) {
        Collection<String> defaultToAdd = PropertiesUtil.toCollection(defaultToAddString);
        Collection<String> defaultToRemove = PropertiesUtil.toCollection(defaultToRemoveString);
        list.add(defaultToAdd);
        list.remove(defaultToRemove);
        Collection<String> toAdd = PropertiesUtil.getPropertyValueAsList(properties, toAddPropertyName);
        Collection<String> toRemove = PropertiesUtil.getPropertyValueAsList(properties, toRemovePropertyName);
        if (toAdd.contains("*") && toRemove.contains("*")) {
            throw new ConfigurationException("cannot use * for " + toAddPropertyName + " and " + toRemovePropertyName + " at the same time");
        }
        if (toRemove.contains("*")) {
            list.remove(toRemove);
            list.add(toAdd);
        } else {
            list.add(toAdd);
            list.remove(toRemove);
        }
    }

    public static int getPropertyValue(Properties props, String name, int defaultValue) {
        String value = props.getProperty(name);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public static boolean getPropertyValue(Properties props, String name, boolean defaultValue) {
        String value = props.getProperty(name);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public static String getPropertyValue(Properties props, String name, String defaultValue) {
        return props.getProperty(name, defaultValue);
    }

    public static float getPropertyValue(Properties properties, String name, float defaultValue) {
        String value = properties.getProperty(name);
        return value != null ? Float.parseFloat(value) : defaultValue;
    }

    public static long getPropertyValue(Properties properties, String name, long defaultValue) {
        String value = properties.getProperty(name);
        return value != null ? Long.parseLong(value) : defaultValue;
    }
}

