/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.util;

import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.esigate.Driver;
import org.esigate.UserContext;
import org.esigate.api.ContainerRequestMediator;
import org.esigate.util.UriUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestHelper {
    private static final String USER_CONTEXT = UserContext.class.getName();
    private static final String BASEURLASURL = URL.class.getName();
    private static final String DRIVER = Driver.class.getName();
    private static final String PARAMETERS = "parameters";
    private static final String CHARACTER_ENCODING = "character encoding";
    private static final String MEDIATOR = ContainerRequestMediator.class.getName();

    public static final UserContext getUserContext(HttpRequest request) {
        return (UserContext)request.getParams().getParameter(USER_CONTEXT);
    }

    public static final void setUserContext(HttpRequest request, UserContext userContext) {
        request.getParams().setParameter(USER_CONTEXT, (Object)userContext);
    }

    public static final URL getBaseUrl(HttpRequest request) {
        return (URL)request.getParams().getParameter(BASEURLASURL);
    }

    public static final void setBaseUrl(HttpRequest request, URL url) {
        request.getParams().setParameter(BASEURLASURL, (Object)url);
    }

    public static final Driver getDriver(HttpRequest request) {
        return (Driver)request.getParams().getParameter(DRIVER);
    }

    public static final void setDriver(HttpRequest request, Driver driver) {
        request.getParams().setParameter(DRIVER, (Object)driver);
    }

    public static final Map<String, String> getParameters(HttpRequest request) {
        return (Map)request.getParams().getParameter(PARAMETERS);
    }

    public static final void setParameters(HttpRequest request, Map<String, String> parameters) {
        request.getParams().setParameter(PARAMETERS, parameters);
    }

    public static final String getFirstHeader(String name, HttpRequest request) {
        Header[] values = request.getHeaders(name);
        if (values.length > 0) {
            return values[0].getValue();
        }
        return null;
    }

    public static final String getCharacterEncoding(HttpRequest request) {
        return (String)request.getParams().getParameter(CHARACTER_ENCODING);
    }

    public static final void setCharacterEncoding(HttpRequest request, String characterEncoding) {
        request.getParams().setParameter(CHARACTER_ENCODING, (Object)characterEncoding);
    }

    public static final String getParameter(HttpRequest request, String name) {
        String characterEncoding = HttpRequestHelper.getCharacterEncoding(request);
        if (characterEncoding == null) {
            characterEncoding = "ISO-8859-1";
        }
        URI uri = UriUtils.createUri(request.getRequestLine().getUri());
        List parameters = URLEncodedUtils.parse((URI)uri, (String)characterEncoding);
        for (NameValuePair nameValuePair : parameters) {
            if (!nameValuePair.getName().equals(name)) continue;
            return nameValuePair.getValue();
        }
        return null;
    }

    public static final HttpHost getHost(HttpRequest request) {
        URI uri = UriUtils.createUri(request.getRequestLine().getUri());
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        Header[] headers = request.getHeaders("Host");
        if (headers != null && headers.length != 0) {
            String headerValue = headers[0].getValue();
            String[] splitted = headerValue.split(":");
            host = splitted[0];
            port = splitted.length > 1 ? Integer.parseInt(splitted[1]) : -1;
        }
        return new HttpHost(host, port, scheme);
    }

    public static final ContainerRequestMediator getMediator(HttpRequest request) {
        return (ContainerRequestMediator)request.getParams().getParameter(MEDIATOR);
    }

    public static final void setMediator(HttpRequest request, ContainerRequestMediator mediator) {
        request.getParams().setParameter(MEDIATOR, (Object)mediator);
    }
}

