/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension;

import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.HttpRequest;
import org.apache.http.client.cache.CacheResponseStatus;
import org.esigate.Driver;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.FragmentEvent;
import org.esigate.extension.Extension;
import org.esigate.http.RedirectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentLogging
implements Extension,
IEventListener {
    private static final String TIME = "org.esigate.time";
    private static final Logger LOG = LoggerFactory.getLogger(FragmentLogging.class);
    private Driver driver;

    public void init(Driver driver, Properties properties) {
        this.driver = driver;
        driver.getEventManager().register(EventManager.EVENT_FRAGMENT_POST, this);
        driver.getEventManager().register(EventManager.EVENT_FRAGMENT_PRE, this);
    }

    public boolean event(EventDefinition id, Event event) {
        FragmentEvent e = (FragmentEvent)event;
        if (EventManager.EVENT_FRAGMENT_PRE.equals(id)) {
            e.httpContext.setAttribute(TIME, (Object)System.currentTimeMillis());
        } else {
            int statusCode = e.httpResponse.getStatusLine().getStatusCode();
            if (LOG.isInfoEnabled() || statusCode >= 400) {
                HttpRequest lastRequest = RedirectStrategy.getLastRequest((HttpRequest)e.httpRequest, e.httpContext);
                String requestLine = lastRequest.getRequestLine().toString();
                String statusLine = e.httpResponse.getStatusLine().toString();
                String reqHeaders = ArrayUtils.toString((Object)lastRequest.getAllHeaders());
                String respHeaders = ArrayUtils.toString((Object)e.httpResponse.getAllHeaders());
                String cache = "";
                CacheResponseStatus cacheResponseStatus = (CacheResponseStatus)e.httpContext.getAttribute("http.cache.response.status");
                if (cacheResponseStatus != null) {
                    cache = cacheResponseStatus.toString();
                }
                long time = System.currentTimeMillis() - (Long)e.httpContext.removeAttribute(TIME);
                String logMessage = this.driver.getConfiguration().getInstanceName() + " " + requestLine + " " + reqHeaders + " -> " + statusLine + " (" + time + " ms) " + cache + " " + respHeaders;
                if (statusCode >= 400) {
                    LOG.warn(logMessage);
                } else {
                    LOG.info(logMessage);
                }
            }
        }
        return true;
    }
}

