/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension;

import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.HttpRequest;
import org.esigate.Driver;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.FetchEvent;
import org.esigate.extension.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchLogging
implements Extension,
IEventListener {
    private static final String TIME = "org.esigate.time.external";
    private static final Logger LOG = LoggerFactory.getLogger(FetchLogging.class);

    public void init(Driver driver, Properties properties) {
        driver.getEventManager().register(EventManager.EVENT_FETCH_POST, this);
        driver.getEventManager().register(EventManager.EVENT_FETCH_PRE, this);
    }

    public boolean event(EventDefinition id, Event event) {
        FetchEvent e = (FetchEvent)event;
        if (EventManager.EVENT_FETCH_POST.equals(id)) {
            int statusCode = e.httpResponse.getStatusLine().getStatusCode();
            if (LOG.isInfoEnabled() || statusCode >= 400) {
                HttpRequest lastRequest = e.httpRequest;
                String url = lastRequest.getRequestLine().toString();
                String status = e.httpResponse.getStatusLine().toString();
                String reqHeaders = ArrayUtils.toString((Object)lastRequest.getAllHeaders());
                String respHeaders = ArrayUtils.toString((Object)e.httpResponse.getAllHeaders());
                long time = System.currentTimeMillis() - (Long)e.httpContext.removeAttribute(TIME);
                String logMessage = url + " " + reqHeaders + " -> " + status + " (" + time + " ms) " + " " + respHeaders;
                if (statusCode >= 400) {
                    LOG.warn(logMessage);
                } else {
                    LOG.info(logMessage);
                }
            }
        } else {
            e.httpContext.setAttribute(TIME, (Object)System.currentTimeMillis());
        }
        return true;
    }
}

