/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.esi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.esi.BaseElement;
import org.esigate.esi.BaseElementType;
import org.esigate.esi.EsiRenderer;
import org.esigate.esi.InlineCache;
import org.esigate.esi.Tag;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContext;
import org.esigate.regexp.ReplaceRenderer;
import org.esigate.util.HttpRequestHelper;
import org.esigate.util.UriUtils;
import org.esigate.vars.VariablesResolver;
import org.esigate.xml.XpathRenderer;
import org.esigate.xml.XsltRenderer;

class IncludeElement
extends BaseElement {
    private static final String PROVIDER_PATTERN = "$(PROVIDER{";
    private static final String LEGACY_PROVIDER_PATTERN = "$PROVIDER({";
    public static final ElementType TYPE = new BaseElementType("<esi:include", "</esi:include"){

        public IncludeElement newInstance() {
            return new IncludeElement();
        }
    };
    private final Appendable outAdapter = new Appendable(){

        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            IncludeElement.this.characters(csq, start, end);
            return this;
        }

        public Appendable append(char c) throws IOException {
            return this.append(new StringBuilder(1).append(c), 0, 1);
        }

        public Appendable append(CharSequence csq) throws IOException {
            return this.append(csq, 0, csq.length());
        }
    };
    private StringBuilder buf;
    private Map<String, CharSequence> fragmentReplacements;
    private Map<String, CharSequence> regexpReplacements;
    private Tag includeTag;
    private boolean write = false;

    IncludeElement() {
    }

    public void characters(CharSequence csq, int start, int end) {
        if (this.write) {
            this.buf.append(csq, start, end);
        }
    }

    public void onTagEnd(String tag, ParserContext ctx) throws IOException, HttpErrorPage {
        block9: {
            this.write = true;
            String src = this.includeTag.getAttribute("src");
            String alt = this.includeTag.getAttribute("alt");
            boolean ignoreError = "continue".equals(this.includeTag.getAttribute("onerror"));
            try {
                this.processPage(src, this.includeTag, ctx);
            }
            catch (IOException e) {
                if (alt != null) {
                    this.processPage(alt, this.includeTag, ctx);
                } else if (!ignoreError && !ctx.reportError(e)) {
                    throw e;
                }
            }
            catch (HttpErrorPage e) {
                if (alt != null) {
                    this.processPage(alt, this.includeTag, ctx);
                }
                if (ignoreError || ctx.reportError(e)) break block9;
                throw e;
            }
        }
        if (!this.regexpReplacements.isEmpty()) {
            for (Map.Entry<String, CharSequence> entry : this.regexpReplacements.entrySet()) {
                this.buf = new StringBuilder(Pattern.compile(entry.getKey()).matcher(this.buf).replaceAll(entry.getValue().toString()));
            }
        }
        ctx.getCurrent().characters(this.buf, 0, this.buf.length());
        this.buf = null;
        this.fragmentReplacements = null;
        this.regexpReplacements = null;
    }

    protected void parseTag(Tag tag, ParserContext ctx) throws IOException, HttpErrorPage {
        this.buf = new StringBuilder();
        this.fragmentReplacements = new HashMap<String, CharSequence>();
        this.regexpReplacements = new HashMap<String, CharSequence>();
        this.includeTag = tag;
    }

    void processPage(String src, Tag tag, ParserContext ctx) throws IOException, HttpErrorPage {
        String provider;
        int endIndex;
        int startIdx;
        Driver driver;
        String page;
        String fragment = tag.getAttribute("fragment");
        String xpath = tag.getAttribute("xpath");
        String xslt = tag.getAttribute("stylesheet");
        boolean rewriteAbsoluteUrl = "true".equalsIgnoreCase(tag.getAttribute("rewriteabsoluteurl"));
        HttpEntityEnclosingRequest httpRequest = ctx.getHttpRequest();
        ArrayList<Renderer> rendererList = new ArrayList<Renderer>();
        int idx = src.indexOf(PROVIDER_PATTERN);
        int idxLegacyPattern = src.indexOf(LEGACY_PROVIDER_PATTERN);
        if (idx < 0 && idxLegacyPattern < 0) {
            page = src;
            driver = HttpRequestHelper.getDriver((HttpRequest)httpRequest);
        } else if (idx >= 0) {
            startIdx = idx + PROVIDER_PATTERN.length();
            endIndex = src.indexOf("})", startIdx);
            provider = src.substring(startIdx, endIndex);
            page = src.substring(endIndex + "})".length());
            driver = DriverFactory.getInstance(provider);
        } else {
            startIdx = idxLegacyPattern + PROVIDER_PATTERN.length();
            endIndex = src.indexOf("})", startIdx);
            provider = src.substring(startIdx, endIndex);
            page = src.substring(endIndex + "})".length());
            driver = DriverFactory.getInstance(provider);
        }
        if (rewriteAbsoluteUrl) {
            HashMap<String, String> replaceRules = new HashMap<String, String>();
            String baseUrl = HttpRequestHelper.getBaseUrl((HttpRequest)httpRequest).toString();
            String visibleBaseUrl = driver.getConfiguration().getVisibleBaseURL(baseUrl);
            String contextBaseUrl = UriUtils.createUri(baseUrl).getPath();
            if (visibleBaseUrl != null && !visibleBaseUrl.equals("") && !baseUrl.equals(visibleBaseUrl)) {
                String contextVisibleBaseUrl = UriUtils.createUri(visibleBaseUrl).getPath();
                replaceRules.put("href=(\"|')" + visibleBaseUrl + "(.*)(\"|')", "href=$1" + contextVisibleBaseUrl + "$2$3");
                replaceRules.put("src=(\"|')" + visibleBaseUrl + "(.*)(\"|')", "src=$1" + contextVisibleBaseUrl + "$2$3");
                replaceRules.put("href=(\"|')" + baseUrl + "(.*)(\"|')", "href=$1" + contextBaseUrl + "$2$3");
                replaceRules.put("src=(\"|')" + baseUrl + "(.*)(\"|')", "src=$1" + contextBaseUrl + "$2$3");
            } else {
                contextBaseUrl = UriUtils.createUri(baseUrl).getPath();
                replaceRules.put("href=(\"|')" + baseUrl + "(.*)(\"|')", "href=$1" + contextBaseUrl + "$2$3");
                replaceRules.put("src=(\"|')" + baseUrl + "(.*)(\"|')", "src=$1" + contextBaseUrl + "$2$3");
            }
            rendererList.add(new ReplaceRenderer(replaceRules));
        }
        page = VariablesResolver.replaceAllVariables(page, (HttpRequest)httpRequest);
        InlineCache ic = InlineCache.getFragment(src);
        if (ic != null && !ic.isExpired()) {
            String cache = ic.getFragment();
            this.characters(cache, 0, cache.length());
        } else {
            EsiRenderer esiRenderer = fragment != null ? new EsiRenderer(page, fragment) : new EsiRenderer();
            if (this.fragmentReplacements != null && !this.fragmentReplacements.isEmpty()) {
                esiRenderer.setFragmentsToReplace(this.fragmentReplacements);
            }
            rendererList.add(esiRenderer);
            if (xpath != null) {
                rendererList.add(new XpathRenderer(xpath));
            } else if (xslt != null) {
                rendererList.add(new XsltRenderer(xslt, driver, httpRequest));
            }
            driver.render(page, null, this.outAdapter, httpRequest, rendererList.toArray(new Renderer[rendererList.size()]));
        }
    }

    void addFragmentReplacement(String fragment, CharSequence replacement) {
        this.fragmentReplacements.put(fragment, replacement);
    }

    void addRegexpReplacement(String regexp, CharSequence replacement) {
        this.regexpReplacements.put(regexp, replacement);
    }
}

