/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.Serializable;
import org.apache.http.HttpRequest;
import org.esigate.util.HttpRequestHelper;

public class UserContext {
    private static final String USER_KEY = "user";
    private final HttpRequest httpRequest;
    private final String key;

    public UserContext(HttpRequest httpRequest, String key) {
        this.httpRequest = httpRequest;
        this.key = UserContext.class.getName() + "#" + key;
    }

    private String prefixAttributeName(String name) {
        return this.key + "#" + name;
    }

    public Object getAttribute(String name) {
        return HttpRequestHelper.getMediator(this.httpRequest).getSessionAttribute(this.prefixAttributeName(name));
    }

    public void setAttribute(String name, Serializable value) {
        HttpRequestHelper.getMediator(this.httpRequest).setSessionAttribute(this.prefixAttributeName(name), value);
    }

    public String getUser() {
        return (String)this.getAttribute(USER_KEY);
    }

    public void setUser(String user) {
        this.setAttribute(USER_KEY, (Serializable)((Object)user));
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("User=").append(this.getUser());
        return result.toString();
    }
}

