/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.util.EntityUtils;
import org.esigate.DriverConfiguration;
import org.esigate.HttpErrorPage;
import org.esigate.Parameters;
import org.esigate.Renderer;
import org.esigate.UserContext;
import org.esigate.cookie.CookieManager;
import org.esigate.events.EventManager;
import org.esigate.events.impl.ProxyEvent;
import org.esigate.events.impl.RenderEvent;
import org.esigate.extension.ExtensionFactory;
import org.esigate.http.GenericHttpRequest;
import org.esigate.http.HttpClientHelper;
import org.esigate.http.HttpResponseUtils;
import org.esigate.http.ResourceUtils;
import org.esigate.util.HttpRequestHelper;
import org.esigate.vars.VariablesResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Driver {
    private static final Logger LOG = LoggerFactory.getLogger(Driver.class);
    private final DriverConfiguration config;
    private HttpClientHelper httpClientHelper;
    private final List<String> parsableContentTypes;
    private final EventManager eventManager;

    private Driver(Properties properties, String name, EventManager eventManagerParam) {
        this.eventManager = eventManagerParam;
        this.config = new DriverConfiguration(name, properties);
        ExtensionFactory.getExtensions(properties, Parameters.EXTENSIONS, this);
        this.parsableContentTypes = new ArrayList<String>();
        String strContentTypes = Parameters.PARSABLE_CONTENT_TYPES.getValueString(properties);
        StringTokenizer tokenizer = new StringTokenizer(strContentTypes, ",");
        while (tokenizer.hasMoreElements()) {
            String contentType = tokenizer.nextToken();
            contentType = contentType.trim();
            this.parsableContentTypes.add(contentType);
        }
    }

    public Driver(String name, Properties properties) {
        this(properties, name, new EventManager());
        CookieManager cookieManager = (CookieManager)ExtensionFactory.getExtension(properties, Parameters.COOKIE_MANAGER, this);
        this.httpClientHelper = new HttpClientHelper(this.eventManager, cookieManager, properties);
    }

    public Driver(String name, Properties properties, HttpClientHelper httpClientHelper) {
        this(properties, name, httpClientHelper.getEventManager());
        this.httpClientHelper = httpClientHelper;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public final void render(String page, Map<String, String> parameters, Appendable writer, HttpEntityEnclosingRequest request, Renderer ... renderers) throws IOException, HttpErrorPage {
        this.initHttpRequestParams((HttpRequest)request, parameters);
        if (LOG.isInfoEnabled()) {
            ArrayList<String> rendererNames = new ArrayList<String>(renderers.length);
            for (Renderer renderer : renderers) {
                rendererNames.add(renderer.getClass().getName());
            }
            LOG.info("render provider={} page= {} renderers={}", new Object[]{this.config.getInstanceName(), page, rendererNames});
        }
        String resultingpage = VariablesResolver.replaceAllVariables(page, (HttpRequest)request);
        String currentValue = this.getResourceAsString(resultingpage, request);
        RenderEvent renderEvent = new RenderEvent();
        renderEvent.originalRequest = request;
        renderEvent.remoteUrl = page;
        renderEvent.renderers = new ArrayList<Renderer>(renderers.length + 1);
        renderEvent.renderers.addAll(Arrays.asList(renderers));
        this.eventManager.fire(EventManager.EVENT_RENDER_PRE, renderEvent);
        for (Renderer renderer : renderEvent.renderers) {
            StringWriter stringWriter = new StringWriter();
            renderer.render(request, currentValue, stringWriter);
            currentValue = stringWriter.toString();
        }
        this.eventManager.fire(EventManager.EVENT_RENDER_POST, renderEvent);
        writer.append(currentValue);
    }

    public void initHttpRequestParams(HttpRequest request, Map<String, String> parameters) throws HttpErrorPage {
        HttpRequestHelper.setDriver(request, this);
        HttpRequestHelper.setParameters(request, parameters);
        UserContext userContext = new UserContext(request, this.config.getInstanceName());
        HttpRequestHelper.setUserContext(request, userContext);
        try {
            URL baseUrl = new URL(this.config.getBaseUrlRetrieveStrategy().getBaseURL(request));
            HttpRequestHelper.setBaseUrl(request, baseUrl);
        }
        catch (MalformedURLException e) {
            throw new HttpErrorPage(500, "Internal server error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proxy(String relUrl, HttpEntityEnclosingRequest request, Renderer ... renderers) throws IOException, HttpErrorPage {
        this.initHttpRequestParams((HttpRequest)request, null);
        if (LOG.isInfoEnabled()) {
            LOG.info("proxy provider={} relUrl={}", (Object)this.config.getInstanceName(), (Object)relUrl);
        }
        HttpRequestHelper.setCharacterEncoding((HttpRequest)request, this.config.getUriEncoding());
        ProxyEvent e = new ProxyEvent();
        e.originalRequest = request;
        this.eventManager.fire(EventManager.EVENT_PROXY_PRE, e);
        if (e.exit) {
            return;
        }
        String url = ResourceUtils.getHttpUrlWithQueryString(relUrl, e.originalRequest, true);
        GenericHttpRequest httpRequest = this.httpClientHelper.createHttpRequest(request, url, true);
        HttpResponse httpResponse = this.execute(httpRequest);
        if (!this.isTextContentType(httpResponse)) {
            LOG.debug("'{}' is binary on no transformation to apply: was forwarded without modification.", (Object)relUrl);
        } else {
            LOG.debug("'{}' is text : will apply renderers.", (Object)relUrl);
            String currentValue = HttpResponseUtils.toString(httpResponse);
            RenderEvent renderEvent = new RenderEvent();
            renderEvent.originalRequest = request;
            renderEvent.remoteUrl = relUrl;
            renderEvent.renderers = new ArrayList<Renderer>(renderers.length + 1);
            renderEvent.renderers.addAll(Arrays.asList(renderers));
            this.eventManager.fire(EventManager.EVENT_RENDER_PRE, renderEvent);
            for (Renderer renderer : renderEvent.renderers) {
                StringWriter stringWriter = new StringWriter();
                renderer.render(request, currentValue, stringWriter);
                currentValue = stringWriter.toString();
            }
            this.eventManager.fire(EventManager.EVENT_RENDER_POST, renderEvent);
            String charsetName = HttpResponseUtils.getContentCharset(httpResponse);
            if (charsetName == null) {
                charsetName = "ISO-8859-1";
            }
            StringEntity transformedHttpEntity = new StringEntity(currentValue, ContentType.get((HttpEntity)httpResponse.getEntity()));
            BasicHttpResponse transformedResponse = new BasicHttpResponse(httpResponse.getStatusLine());
            transformedResponse.setHeaders(httpResponse.getAllHeaders());
            transformedResponse.setEntity((HttpEntity)transformedHttpEntity);
            httpResponse = transformedResponse;
        }
        try {
            HttpRequestHelper.getMediator((HttpRequest)request).sendResponse(httpResponse);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }
        this.eventManager.fire(EventManager.EVENT_PROXY_POST, e);
    }

    protected String getResourceAsString(String url, HttpEntityEnclosingRequest originalRequest) throws HttpErrorPage {
        String result;
        url = VariablesResolver.replaceAllVariables(url, (HttpRequest)originalRequest);
        url = ResourceUtils.getHttpUrlWithQueryString(url, (HttpRequest)originalRequest, false);
        boolean cacheable = "GET".equalsIgnoreCase(originalRequest.getRequestLine().getMethod());
        if (cacheable && (result = (String)originalRequest.getParams().getParameter(url)) != null) {
            return result;
        }
        GenericHttpRequest httpRequest = this.httpClientHelper.createHttpRequest(originalRequest, url, false);
        HttpResponse httpResponse = this.execute(httpRequest);
        result = HttpResponseUtils.toString(httpResponse);
        if (cacheable) {
            originalRequest.getParams().setParameter(url, (Object)result);
        }
        return result;
    }

    public DriverConfiguration getConfiguration() {
        return this.config;
    }

    private boolean isTextContentType(HttpResponse httpResponse) {
        String contentType = HttpResponseUtils.getFirstHeader("Content-Type", httpResponse);
        return this.isTextContentType(contentType);
    }

    protected boolean isTextContentType(String contentType) {
        if (contentType != null) {
            String lowerContentType = contentType.toLowerCase();
            for (String textContentType : this.parsableContentTypes) {
                if (!lowerContentType.startsWith(textContentType)) continue;
                return true;
            }
        }
        return false;
    }

    public HttpResponse executeSingleRequest(GenericHttpRequest httpRequest) {
        return this.httpClientHelper.execute(httpRequest);
    }

    private HttpResponse execute(GenericHttpRequest httpRequest) throws HttpErrorPage {
        HttpResponse httpResponse = this.executeSingleRequest(httpRequest);
        if (httpResponse == null) {
            throw new HttpErrorPage(500, "Request was cancelled by server", "Request was cancelled by server");
        }
        if (HttpResponseUtils.isError(httpResponse)) {
            throw new HttpErrorPage(httpResponse);
        }
        return httpResponse;
    }
}

