/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.aggregator.AggregateRenderer;
import org.esigate.esi.EsiRenderer;
import org.esigate.servlet.HttpServletMediator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatorServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AggregatorServlet.class);
    private String provider = null;
    private Map<String, String> providerMappings = null;

    public Map<String, String> getProviderMappings() {
        return this.providerMappings;
    }

    public Driver getDriver(String name) {
        return DriverFactory.getInstance(name);
    }

    public String selectProvider(HttpServletRequest request) {
        String mapping;
        String host;
        String targetProvider = this.provider;
        if (this.providerMappings != null && (host = request.getHeader("Host")) != null && (mapping = this.providerMappings.get(host = host.toLowerCase(Locale.ENGLISH))) != null) {
            targetProvider = mapping;
        }
        return targetProvider;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String relUrl = request.getRequestURI();
        relUrl = relUrl.substring(request.getContextPath().length());
        if (request.getServletPath() != null) {
            relUrl = relUrl.substring(request.getServletPath().length());
        }
        LOG.debug("Aggregating {}", (Object)relUrl);
        String targetProvider = this.selectProvider(request);
        HttpServletMediator mediator = new HttpServletMediator(request, response, this.getServletContext());
        try {
            this.getDriver(targetProvider).proxy(relUrl, mediator.getHttpRequest(), new AggregateRenderer(), new EsiRenderer());
        }
        catch (HttpErrorPage e) {
            mediator.sendResponse(e.getHttpResponse());
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.provider = config.getInitParameter("provider");
        String providersString = config.getInitParameter("providers");
        if (providersString != null) {
            String[] providersArray;
            this.providerMappings = new HashMap<String, String>();
            for (String p : providersArray = StringUtils.split((String)providersString, (String)",")) {
                String[] mapping = StringUtils.split((String)p, (String)"=");
                this.providerMappings.put(StringUtils.trim((String)mapping[0].toLowerCase(Locale.ENGLISH)), StringUtils.trim((String)mapping[1]));
            }
        }
    }
}

