/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.util.EntityUtils;
import org.esigate.HttpErrorPage;
import org.esigate.http.IOExceptionHandler;
import org.esigate.http.UnsupportedContentEncodingException;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseUtils.class);

    public static boolean isError(HttpResponse httpResponse) {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        return statusCode != 200 && statusCode != 302 && statusCode != 301 && statusCode != 304;
    }

    public static String getFirstHeader(String headerName, HttpResponse httpResponse) {
        Header header = httpResponse.getFirstHeader(headerName);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public static String getContentCharset(HttpResponse httpResponse) {
        Charset charset;
        ContentType contentType = ContentType.get((HttpEntity)httpResponse.getEntity());
        if (contentType != null && (charset = contentType.getCharset()) != null) {
            return charset.name();
        }
        return null;
    }

    public static void release(HttpResponse httpResponse) {
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            try {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
            catch (IOException e) {
                LOG.debug("Could not release request. Usualy this is due to a client abort.");
            }
        }
    }

    public static String removeSessionId(String src, HttpResponse httpResponse) {
        BrowserCompatSpec cookieSpec = new BrowserCompatSpec();
        CookieOrigin cookieOrigin = new CookieOrigin("dummy", 80, "/", false);
        Header[] responseHeaders = httpResponse.getHeaders("Set-cookie");
        String jsessionid = null;
        for (int i = 0; i < responseHeaders.length; ++i) {
            Header header = responseHeaders[i];
            try {
                Cookie cookie;
                List cookies = cookieSpec.parse(header, cookieOrigin);
                Iterator i$ = cookies.iterator();
                if (i$.hasNext() && "JSESSIONID".equalsIgnoreCase((cookie = (Cookie)i$.next()).getName())) {
                    jsessionid = cookie.getValue();
                }
            }
            catch (MalformedCookieException ex) {
                LOG.warn("Malformed header: " + header.getName() + ": " + header.getValue());
            }
            if (jsessionid != null) break;
        }
        if (jsessionid == null) {
            return src;
        }
        return UriUtils.removeSessionId(jsessionid, src);
    }

    public static String toString(HttpResponse httpResponse) throws HttpErrorPage {
        String result;
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            result = httpResponse.getStatusLine().getReasonPhrase();
        } else {
            Header contentEncoding = httpEntity.getContentEncoding();
            if (contentEncoding != null) {
                String contentEncodingValue = contentEncoding.getValue();
                if ("gzip".equalsIgnoreCase(contentEncodingValue) || "x-gzip".equalsIgnoreCase(contentEncodingValue)) {
                    httpEntity = new GzipDecompressingEntity(httpEntity);
                } else if ("deflate".equalsIgnoreCase(contentEncodingValue)) {
                    httpEntity = new DeflateDecompressingEntity(httpEntity);
                } else {
                    throw new UnsupportedContentEncodingException("Content-encoding \"" + contentEncoding + "\" is not supported");
                }
            }
            try {
                result = EntityUtils.toString((HttpEntity)httpEntity);
            }
            catch (IOException e) {
                throw new HttpErrorPage(IOExceptionHandler.toHttpResponse(e));
            }
        }
        return HttpResponseUtils.removeSessionId(result, httpResponse);
    }
}

