/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.IEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager {
    public static EventDefinition EVENT_FRAGMENT_PRE = new EventDefinition("org.esigate.fragement-pre", 1);
    public static EventDefinition EVENT_FRAGMENT_POST = new EventDefinition("org.esigate.fragment-post", 2);
    public static EventDefinition EVENT_FETCH_PRE = new EventDefinition("org.esigate.fetch-pre", 1);
    public static EventDefinition EVENT_FETCH_POST = new EventDefinition("org.esigate.fetch-post", 2);
    public static EventDefinition EVENT_PROXY_PRE = new EventDefinition("org.esigate.proxy-pre", 1);
    public static EventDefinition EVENT_PROXY_POST = new EventDefinition("org.esigate.proxy-post", 2);
    public static EventDefinition EVENT_RENDER_PRE = new EventDefinition("org.esigate.render-pre", 1);
    public static EventDefinition EVENT_RENDER_POST = new EventDefinition("org.esigate.render-post", 2);
    private static final Logger LOG = LoggerFactory.getLogger(EventManager.class);
    Map<EventDefinition, List<IEventListener>> listeners = new HashMap<EventDefinition, List<IEventListener>>();
    Map<EventDefinition, List<IEventListener>> listenersPost = new HashMap<EventDefinition, List<IEventListener>>();

    private void register(Map<EventDefinition, List<IEventListener>> listenerMappings, EventDefinition eventDefinition, IEventListener listener, boolean reverseOrder) {
        List<IEventListener> eventListeners = listenerMappings.get(eventDefinition);
        if (eventListeners == null) {
            eventListeners = new ArrayList<IEventListener>();
            listenerMappings.put(eventDefinition, eventListeners);
        }
        if (reverseOrder) {
            eventListeners.add(eventListeners.size(), listener);
        } else {
            eventListeners.add(listener);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Registered {} on event {}", (Object)listener.getClass().getName(), (Object)eventDefinition);
        }
    }

    public void register(EventDefinition eventDefinition, IEventListener listener) {
        if (eventDefinition.getType() == 2) {
            this.register(this.listenersPost, eventDefinition, listener, true);
        } else {
            this.register(this.listeners, eventDefinition, listener, false);
        }
    }

    public void fire(EventDefinition eventDefinition, Event eventDetails) {
        if (eventDefinition.getType() == 2) {
            this.fire(this.listenersPost, eventDefinition, eventDetails);
        } else {
            this.fire(this.listeners, eventDefinition, eventDetails);
        }
    }

    private void fire(Map<EventDefinition, List<IEventListener>> listenerMappings, EventDefinition eventDefinition, Event eventDetails) {
        List<IEventListener> eventListeners = listenerMappings.get(eventDefinition);
        if (eventListeners == null) {
            return;
        }
        for (IEventListener el : eventListeners) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running {} on event {}", (Object)el, (Object)eventDefinition);
            }
            if (el.event(eventDefinition, eventDetails)) continue;
            return;
        }
    }

    public void unregister(EventDefinition eventDefinition, IEventListener eventListener) {
        if (eventDefinition.getType() == 2) {
            this.unregister(this.listenersPost, eventDefinition, eventListener);
        } else {
            this.unregister(this.listeners, eventDefinition, eventListener);
        }
    }

    private void unregister(Map<EventDefinition, List<IEventListener>> listenerMappings, EventDefinition eventDefinition, IEventListener listener) {
        List<IEventListener> eventListeners = listenerMappings.get(eventDefinition);
        if (eventListeners == null) {
            return;
        }
        boolean removed = eventListeners.remove(listener);
        if (LOG.isInfoEnabled() && removed) {
            LOG.info("Unregistered {} on event {}", (Object)listener.getClass().getName(), (Object)eventDefinition);
        }
    }
}

