/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.util.Properties;
import org.apache.http.client.HttpClient;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.esigate.ConfigurationException;
import org.esigate.Parameters;
import org.esigate.cache.CacheAdapter;
import org.esigate.cache.CacheStorage;
import org.esigate.events.EventManager;

public class CacheConfigHelper {
    public static final CacheConfig createCacheConfig(Properties properties) {
        boolean heuristicCachingEnabled = Parameters.HEURISTIC_CACHING_ENABLED.getValueBoolean(properties);
        float heuristicCoefficient = Parameters.HEURISTIC_COEFFICIENT.getValueFloat(properties);
        long heuristicDefaultLifetimeSecs = Parameters.HEURISTIC_DEFAULT_LIFETIME_SECS.getValueLong(properties);
        int maxCacheEntries = Parameters.MAX_CACHE_ENTRIES.getValueInt(properties);
        long maxObjectSize = Parameters.MAX_OBJECT_SIZE.getValueLong(properties);
        int minAsynchronousWorkers = Parameters.MIN_ASYNCHRONOUS_WORKERS.getValueInt(properties);
        int maxAsynchronousWorkers = Parameters.MAX_ASYNCHRONOUS_WORKERS.getValueInt(properties);
        int asynchronousWorkerIdleLifetimeSecs = Parameters.ASYNCHRONOUS_WORKER_IDLE_LIFETIME_SECS.getValueInt(properties);
        int maxUpdateRetries = Parameters.MAX_UPDATE_RETRIES.getValueInt(properties);
        int revalidationQueueSize = Parameters.REVALIDATION_QUEUE_SIZE.getValueInt(properties);
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setHeuristicCachingEnabled(heuristicCachingEnabled);
        cacheConfig.setHeuristicCoefficient(heuristicCoefficient);
        cacheConfig.setHeuristicDefaultLifetime(heuristicDefaultLifetimeSecs);
        cacheConfig.setMaxCacheEntries(maxCacheEntries);
        if (maxObjectSize > 0L) {
            cacheConfig.setMaxObjectSize(maxObjectSize);
        } else {
            cacheConfig.setMaxObjectSize(Long.MAX_VALUE);
        }
        cacheConfig.setAsynchronousWorkersCore(minAsynchronousWorkers);
        cacheConfig.setAsynchronousWorkersMax(maxAsynchronousWorkers);
        cacheConfig.setAsynchronousWorkerIdleLifetimeSecs(asynchronousWorkerIdleLifetimeSecs);
        cacheConfig.setMaxUpdateRetries(maxUpdateRetries);
        cacheConfig.setRevalidationQueueSize(revalidationQueueSize);
        return cacheConfig;
    }

    public static final HttpClient addCache(EventManager d, Properties properties, HttpClient backend) {
        Object cacheStorage;
        String cacheStorageClass = Parameters.CACHE_STORAGE.getValueString(properties);
        try {
            cacheStorage = Class.forName(cacheStorageClass).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not instantiate cacheStorageClass", e);
        }
        if (!(cacheStorage instanceof CacheStorage)) {
            throw new ConfigurationException("Cache storage class must extend org.esigate.cache.CacheStorage.");
        }
        ((CacheStorage)cacheStorage).init(properties);
        CacheConfig cacheConfig = CacheConfigHelper.createCacheConfig(properties);
        cacheConfig.setSharedCache(true);
        CacheAdapter cacheAdapter = new CacheAdapter();
        cacheAdapter.init(properties);
        HttpClient cachingHttpClient = cacheAdapter.wrapBackendHttpClient(d, backend);
        cachingHttpClient = new CachingHttpClient(cachingHttpClient, (HttpCacheStorage)cacheStorage, cacheConfig);
        cachingHttpClient = cacheAdapter.wrapCachingHttpClient(cachingHttpClient);
        return cachingHttpClient;
    }
}

